dofile("data/scripts/lib/mod_settings.lua") -- see this file for documentation on some of the features.

local mod_id = "regenerating_shield" -- This should match the name of your mod's folder.
mod_settings_version = 1 -- This is a magic global that can be used to migrate settings to new mod versions. call mod_settings_get_version() before mod_settings_update() to get the old value. 
mod_settings = 
{
	{
		category_id = "regenerating_shield_config",
		ui_name = "CONFIG",
		ui_description = "Customise to your liking!",
		settings = {
			{
				id = "percent",
				ui_name = "Shield scales with max hp",
				ui_description = "If the max shield is instead a percentage of max health, rather then a flat value.",
				value_default = false,
				scope = MOD_SETTING_SCOPE_RUNTIME,
			},
			{
				id = "max_shield",
				ui_name = "Max Shield",
				ui_description = "The amount of health your shield has at full capacity.",
				value_default = "15",
				text_max_length = 3,
				allowed_characters = "0123456789",
				scope = MOD_SETTING_SCOPE_RUNTIME,
			},
			{
				id = "rebuild_cooldown",
				ui_name = "Rebuild Cooldown",
				ui_description = "How long (in seconds) you have to avoid damage for the shield to start rebuilding its health.",
				value_default = "10",
				text_max_length = 3,
				allowed_characters = "0123456789",
				scope = MOD_SETTING_SCOPE_RUNTIME,
			},
			{	
				id = "rebuild_percent",
				ui_name = "Rebuild rate scales with max shield",
				ui_description = "If the rebuild rate is instead a percentage of max shield per second, rather then a flat value.",
				value_default = false,
				scope = MOD_SETTING_SCOPE_RUNTIME,
			},
			{
				id = "rebuild_rate",
				ui_name = "Rebuild Rate",
				ui_description = "How fast (in hp/second) the sheild rebuilds itself after the cooldown is over.",
				value_default = "1",
				text_max_length = 3,
				allowed_characters = "0123456789",
				scope = MOD_SETTING_SCOPE_RUNTIME,
			},
			{	
				id = "overdamage_protection",
				ui_name = "Overdamage Protection",
				ui_description = "If an attack breaks the shield, prevent any damage from being inflicted into the health bar.\nMore noticable with single instance high-damage attacks",
				value_default = false,
				scope = MOD_SETTING_SCOPE_RUNTIME,
			},
		},
	},
	{
		category_id = "regenerating_shield_perk",
		ui_name = "PERK CONFIG",
		ui_description = "Customise to your liking!",
		settings = {
			{
				id = "make_perk",
				ui_name = "Add perk",
				ui_description = "Makes the Regenerating Shield a perk. All other settings in this catagory are ignored if this is disabled.",
				value_default = true,
				scope = MOD_SETTING_SCOPE_NEW_GAME,
			},
			{
				id = "start_with_perk",
				ui_name = "Start with shield perk",
				ui_description = "Makes you start with the Regenerating Shield perk.\nYou get the regenerating shield regardless of this setting if \"Add Perk\" is disabled",
				value_default = true,
				scope = MOD_SETTING_SCOPE_NEW_GAME,
			},
			{
				id = "max_shield_stack",
				ui_name = "Stack max shield increase",
				ui_description = "How much each Regenerating Shield perk after the first one increases the max shield.",
				value_default = "10",
				text_max_length = 3,
				allowed_characters = "0123456789",
				scope = MOD_SETTING_SCOPE_RUNTIME,
			},
			{
				id = "rebuild_cooldown_stack",
				ui_name = "Stack rebuild cooldown decrease",
				ui_description = "How much each Regenerating Shield perk after the first one decreases the rebuild cooldown.",
				value_default = "0",
				text_max_length = 3,
				allowed_characters = "0123456789",
				scope = MOD_SETTING_SCOPE_RUNTIME,
			},
			{
				id = "rebuild_rate_stack",
				ui_name = "Stack rebuild rate increase",
				ui_description = "How much each Regenerating Shield perk after the first one increases the rebuild rate.",
				value_default = "0",
				text_max_length = 3,
				allowed_characters = "0123456789",
				scope = MOD_SETTING_SCOPE_RUNTIME,
			},
		},
	},
}

function ModSettingsUpdate( init_scope )
	local old_version = mod_settings_get_version( mod_id ) -- This can be used to migrate some settings between mod versions.
	mod_settings_update( mod_id, mod_settings, init_scope )
end
function ModSettingsGuiCount()
	return mod_settings_gui_count( mod_id, mod_settings )
end
function ModSettingsGui( gui, in_main_menu )
	mod_settings_gui( mod_id, mod_settings, gui, in_main_menu )
end
