dofile_once("data/scripts/perks/perk.lua")
function OnPlayerSpawned( player_entity ) -- This runs when player entity has been created
	
	local flag = "shieldapplied"
	local flagupd1 = "shieldapplied_flagupd1"
	
	local max_shield_value = tonumber(ModSettingGet("regenerating_shield.max_shield"))/25
	
	if GlobalsGetValue(flag, "0") == "0" then
	
		if ModSettingGet("regenerating_shield.start_with_perk") and ModSettingGet("regenerating_shield.make_perk") then
			EntityLoad("mods/regenerating_shield/files/perk_granter.xml", 0, 0)
		end
	
		EntityAddComponent2( player_entity, "LuaComponent", {
			script_source_file="mods/regenerating_shield/files/scripts/hp_shield_upd.lua",
			script_damage_received="mods/regenerating_shield/files/scripts/hp_shield.lua",
			execute_every_n_frame=1,
			_enabled=true,
		})
		EntityAddComponent2( player_entity, "VariableStorageComponent", {
			_tags="hp_shield_value",
			value_float=max_shield_value,
			value_int=0
		})
	end
	
	if GlobalsGetValue(flagupd1, "0") == "0" then
		EntityAddComponent2( player_entity, "VariableStorageComponent", {
			_tags="frames_last_hit",
			value_int=0
		})
	end
	
	GlobalsSetValue(flag, "1")
	GlobalsSetValue(flagupd1, "1")
end

if ModSettingGet("regenerating_shield.make_perk") then
	ModLuaFileAppend("data/scripts/perks/perk_list.lua","mods/regenerating_shield/files/scripts/perk_list.lua")
end

content = ModTextFileGetContent("data/translations/common.csv")
ModTextFileSetContent("data/translations/common.csv", content .. [[
perkdesc_regenerating_shield,"Adds a small, replenishing buffer to your health",,,,,,,,,,,,,
]])
