function damage_received( damage, message, entity_thats_responsible, is_fatal, projectile_thats_responsible )
	
	local stacks = tonumber(GlobalsGetValue( "regenerating_shield_stacks", 0 ))

	if stacks == 0 and ModSettingGet("regenerating_shield.make_perk") then return end
	
	if damage < 0 then return end
	
	local entity_id = GetUpdatedEntityID()
	local comp = EntityGetFirstComponent( entity_id, "VariableStorageComponent", "hp_shield_value" )
	local shield_value = ComponentGetValue2(comp, "value_float")
	local heal_amount = damage
	
	ComponentSetValue2(comp, "value_int", 0)
	
	if shield_value <= 0 then return end
	
	local shield_new = shield_value-damage
	
	if shield_new < 0 then
		heal_amount = heal_amount + shield_new
	
		shield_new = 0
	end
	
	local hpcomp = EntityGetFirstComponent(entity_id, "DamageModelComponent")
	local hp = ComponentGetValue2(hpcomp, "hp")
	local max_hp = ComponentGetValue2(hpcomp, "max_hp")
	
	local hp_new = hp+heal_amount
	
	if hp_new < 0 then
		hp_new = 0
	end
	ComponentSetValue2(hpcomp, "hp", hp_new)
	ComponentSetValue2(comp, "value_float", shield_new)
	
	local x,y = EntityGetFirstHitboxCenter(entity_id)
	local framecomp = EntityGetFirstComponent(entity_id, "VariableStorageComponent", "frames_last_hit")
	if shield_new == 0 then
		EntityLoad("mods/regenerating_shield/files/gfx/shield_smash.xml", x, y)
		ComponentSetValue2(framecomp, "value_int", 0)
	elseif ComponentGetValue2(framecomp, "value_int")  > 30 or damage > max_hp*0.1 then
		EntityLoad("mods/regenerating_shield/files/gfx/shield_hit.xml", x, y)
		ComponentSetValue2(framecomp, "value_int", 0)
	end
	EntityLoad("mods/regenerating_shield/files/gfx/shield_flash.xml", x, y)
end

function test()
	dofile_once("data/scripts/perks/perk.lua")
	local perk = perk_spawn(0, 0, "REGENERATING_SHIELD_SHIELD")
end