--[[
* Addons - Copyright (c) 2021 Ashita Development Team
* Contact: https://www.ashitaxi.com/
* Contact: https://discord.gg/Ashita
*
* This file is part of Ashita.
*
* Ashita is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Ashita is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Ashita.  If not, see <https://www.gnu.org/licenses/>.
--]]

--[[
* This file is manually constructed from the ImGui C++ source files.
* Currently based on version: 1.80 (58075c4414b985b352d10718b02a8c43f25efd7c)
*
* This file must match the information of the internal Ashita version of ImGui!
* Please do not edit this file!
--]]

local bit = require('bit');

-- Create a helper table for ImGui functions as well as inherit from the main IGuiManager..
local imgui = { };
local imgui_mt = {
    __index = AshitaCore:GetGuiManager();
};
setmetatable(imgui, imgui_mt);

--[[
* General Constants
--]]

FLT_MAX = 3.402823466e+38;

--[[
* ImGui Constants
--]]

IMGUI_VERSION = '1.80';
IMGUI_VERSION_NUM = 18000;

--[[
* Gui Window Flags
--]]

ImGuiWindowFlags_None                           = 0;
ImGuiWindowFlags_NoTitleBar                     = bit.lshift(1, 0);   -- Disable title-bar
ImGuiWindowFlags_NoResize                       = bit.lshift(1, 1);   -- Disable user resizing with the lower-right grip
ImGuiWindowFlags_NoMove                         = bit.lshift(1, 2);   -- Disable user moving the window
ImGuiWindowFlags_NoScrollbar                    = bit.lshift(1, 3);   -- Disable scrollbars (window can still scroll with mouse or programmatically)
ImGuiWindowFlags_NoScrollWithMouse              = bit.lshift(1, 4);   -- Disable user vertically scrolling with mouse wheel. On child window, mouse wheel will be forwarded to the parent unless NoScrollbar is also set.
ImGuiWindowFlags_NoCollapse                     = bit.lshift(1, 5);   -- Disable user collapsing window by double-clicking on it
ImGuiWindowFlags_AlwaysAutoResize               = bit.lshift(1, 6);   -- Resize every window to its content every frame
ImGuiWindowFlags_NoBackground                   = bit.lshift(1, 7);   -- Disable drawing background color (WindowBg, etc.) and outside border. Similar as using SetNextWindowBgAlpha(0.0f).
ImGuiWindowFlags_NoSavedSettings                = bit.lshift(1, 8);   -- Never load/save settings in .ini file
ImGuiWindowFlags_NoMouseInputs                  = bit.lshift(1, 9);   -- Disable catching mouse, hovering test with pass through.
ImGuiWindowFlags_MenuBar                        = bit.lshift(1, 10);  -- Has a menu-bar
ImGuiWindowFlags_HorizontalScrollbar            = bit.lshift(1, 11);  -- Allow horizontal scrollbar to appear (off by default). You may use SetNextWindowContentSize(ImVec2(width,0.0f)); prior to calling Begin() to specify width. Read code in imgui_demo in the "Horizontal Scrolling" section.
ImGuiWindowFlags_NoFocusOnAppearing             = bit.lshift(1, 12);  -- Disable taking focus when transitioning from hidden to visible state
ImGuiWindowFlags_NoBringToFrontOnFocus          = bit.lshift(1, 13);  -- Disable bringing window to front when taking focus (e.g. clicking on it or programmatically giving it focus)
ImGuiWindowFlags_AlwaysVerticalScrollbar        = bit.lshift(1, 14);  -- Always show vertical scrollbar (even if ContentSize.y < Size.y)
ImGuiWindowFlags_AlwaysHorizontalScrollbar      = bit.lshift(1, 15);  -- Always show horizontal scrollbar (even if ContentSize.x < Size.x)
ImGuiWindowFlags_AlwaysUseWindowPadding         = bit.lshift(1, 16);  -- Ensure child windows without border uses style.WindowPadding (ignored by default for non-bordered child windows, because more convenient)
ImGuiWindowFlags_NoNavInputs                    = bit.lshift(1, 18);  -- No gamepad/keyboard navigation within the window
ImGuiWindowFlags_NoNavFocus                     = bit.lshift(1, 19);  -- No focusing toward this window with gamepad/keyboard navigation (e.g. skipped by CTRL+TAB)
ImGuiWindowFlags_UnsavedDocument                = bit.lshift(1, 20);  -- Append '*' to title without affecting the ID, as a convenience to avoid using the ### operator. When used in a tab/docking context, tab is selected on closure and closure is deferred by one frame to allow code to cancel the closure (with a confirmation popup, etc.) without flicker.
ImGuiWindowFlags_NoNav                          = bit.bor(ImGuiWindowFlags_NoNavInputs, ImGuiWindowFlags_NoNavFocus);
ImGuiWindowFlags_NoDecoration                   = bit.bor(ImGuiWindowFlags_NoTitleBar, ImGuiWindowFlags_NoResize, ImGuiWindowFlags_NoScrollbar, ImGuiWindowFlags_NoCollapse);
ImGuiWindowFlags_NoInputs                       = bit.bor(ImGuiWindowFlags_NoMouseInputs, ImGuiWindowFlags_NoNavInputs, ImGuiWindowFlags_NoNavFocus);
-- [Internal]
ImGuiWindowFlags_NavFlattened                   = bit.lshift(1, 23);  -- [BETA] Allow gamepad/keyboard navigation to cross over parent border to this child (only use on child that have no scrolling!)
ImGuiWindowFlags_ChildWindow                    = bit.lshift(1, 24);  -- Don't use! For internal use by BeginChild()
ImGuiWindowFlags_Tooltip                        = bit.lshift(1, 25);  -- Don't use! For internal use by BeginTooltip()
ImGuiWindowFlags_Popup                          = bit.lshift(1, 26);  -- Don't use! For internal use by BeginPopup()
ImGuiWindowFlags_Modal                          = bit.lshift(1, 27);  -- Don't use! For internal use by BeginPopupModal()
ImGuiWindowFlags_ChildMenu                      = bit.lshift(1, 28);  -- Don't use! For internal use by BeginMenu()

--[[
* Gui Input Text Flags
--]]

ImGuiInputTextFlags_None                        = 0;
ImGuiInputTextFlags_CharsDecimal                = bit.lshift(1, 0);   -- Allow 0123456789.+-*/
ImGuiInputTextFlags_CharsHexadecimal            = bit.lshift(1, 1);   -- Allow 0123456789ABCDEFabcdef
ImGuiInputTextFlags_CharsUppercase              = bit.lshift(1, 2);   -- Turn a..z into A..Z
ImGuiInputTextFlags_CharsNoBlank                = bit.lshift(1, 3);   -- Filter out spaces, tabs
ImGuiInputTextFlags_AutoSelectAll               = bit.lshift(1, 4);   -- Select entire text when first taking mouse focus
ImGuiInputTextFlags_EnterReturnsTrue            = bit.lshift(1, 5);   -- Return 'true' when Enter is pressed (as opposed to every time the value was modified). Consider looking at the IsItemDeactivatedAfterEdit() function.
ImGuiInputTextFlags_CallbackCompletion          = bit.lshift(1, 6);   -- Callback on pressing TAB (for completion handling)
ImGuiInputTextFlags_CallbackHistory             = bit.lshift(1, 7);   -- Callback on pressing Up/Down arrows (for history handling)
ImGuiInputTextFlags_CallbackAlways              = bit.lshift(1, 8);   -- Callback on each iteration. User code may query cursor position, modify text buffer.
ImGuiInputTextFlags_CallbackCharFilter          = bit.lshift(1, 9);   -- Callback on character inputs to replace or discard them. Modify 'EventChar' to replace or discard, or return 1 in callback to discard.
ImGuiInputTextFlags_AllowTabInput               = bit.lshift(1, 10);  -- Pressing TAB input a '\t' character into the text field
ImGuiInputTextFlags_CtrlEnterForNewLine         = bit.lshift(1, 11);  -- In multi-line mode, unfocus with Enter, add new line with Ctrl+Enter (default is opposite: unfocus with Ctrl+Enter, add line with Enter).
ImGuiInputTextFlags_NoHorizontalScroll          = bit.lshift(1, 12);  -- Disable following the cursor horizontally
ImGuiInputTextFlags_AlwaysInsertMode            = bit.lshift(1, 13);  -- Insert mode
ImGuiInputTextFlags_ReadOnly                    = bit.lshift(1, 14);  -- Read-only mode
ImGuiInputTextFlags_Password                    = bit.lshift(1, 15);  -- Password mode, display all characters as '*'
ImGuiInputTextFlags_NoUndoRedo                  = bit.lshift(1, 16);  -- Disable undo/redo. Note that input text owns the text data while active, if you want to provide your own undo/redo stack you need e.g. to call ClearActiveID().
ImGuiInputTextFlags_CharsScientific             = bit.lshift(1, 17);  -- Allow 0123456789.+-*/eE (Scientific notation input)
ImGuiInputTextFlags_CallbackResize              = bit.lshift(1, 18);  -- Callback on buffer capacity changes request (beyond 'buf_size' parameter value), allowing the string to grow. Notify when the string wants to be resized (for string types which hold a cache of their Size). You will be provided a new BufSize in the callback and NEED to honor it. (see misc/cpp/imgui_stdlib.h for an example of using this)
ImGuiInputTextFlags_CallbackEdit                = bit.lshift(1, 19);  -- Callback on any edit (note that InputText() already returns true on edit, the callback is useful mainly to manipulate the underlying buffer while focus is active)
-- [Internal]
ImGuiInputTextFlags_Multiline                   = bit.lshift(1, 20);  -- For internal use by InputTextMultiline()
ImGuiInputTextFlags_NoMarkEdited                = bit.lshift(1, 21);  -- For internal use by functions using InputText() before reformatting data

--[[
* Gui Tree Node Flags
--]]

ImGuiTreeNodeFlags_None                         = 0;
ImGuiTreeNodeFlags_Selected                     = bit.lshift(1, 0);   -- Draw as selected
ImGuiTreeNodeFlags_Framed                       = bit.lshift(1, 1);   -- Draw frame with background (e.g. for CollapsingHeader)
ImGuiTreeNodeFlags_AllowItemOverlap             = bit.lshift(1, 2);   -- Hit testing to allow subsequent widgets to overlap this one
ImGuiTreeNodeFlags_NoTreePushOnOpen             = bit.lshift(1, 3);   -- Don't do a TreePush() when open (e.g. for CollapsingHeader) = no extra indent nor pushing on ID stack
ImGuiTreeNodeFlags_NoAutoOpenOnLog              = bit.lshift(1, 4);   -- Don't automatically and temporarily open node when Logging is active (by default logging will automatically open tree nodes)
ImGuiTreeNodeFlags_DefaultOpen                  = bit.lshift(1, 5);   -- Default node to be open
ImGuiTreeNodeFlags_OpenOnDoubleClick            = bit.lshift(1, 6);   -- Need double-click to open node
ImGuiTreeNodeFlags_OpenOnArrow                  = bit.lshift(1, 7);   -- Only open when clicking on the arrow part. If ImGuiTreeNodeFlags_OpenOnDoubleClick is also set, single-click arrow or double-click all box to open.
ImGuiTreeNodeFlags_Leaf                         = bit.lshift(1, 8);   -- No collapsing, no arrow (use as a convenience for leaf nodes).
ImGuiTreeNodeFlags_Bullet                       = bit.lshift(1, 9);   -- Display a bullet instead of arrow
ImGuiTreeNodeFlags_FramePadding                 = bit.lshift(1, 10);  -- Use FramePadding (even for an unframed text node) to vertically align text baseline to regular widget height. Equivalent to calling AlignTextToFramePadding().
ImGuiTreeNodeFlags_SpanAvailWidth               = bit.lshift(1, 11);  -- Extend hit box to the right-most edge, even if not framed. This is not the default in order to allow adding other items on the same line. In the future we may refactor the hit system to be front-to-back, allowing natural overlaps and then this can become the default.
ImGuiTreeNodeFlags_SpanFullWidth                = bit.lshift(1, 12);  -- Extend hit box to the left-most and right-most edges (bypass the indented area).
ImGuiTreeNodeFlags_NavLeftJumpsBackHere         = bit.lshift(1, 13);  -- (WIP) Nav: left direction may move to this TreeNode() from any of its child (items submitted between TreeNode and TreePop)
--ImGuiTreeNodeFlags_NoScrollOnOpen             = bit.lshift(1, 14);  -- FIXME: TODO: Disable automatic scroll on TreePop() if node got just open and contents is not visible
ImGuiTreeNodeFlags_CollapsingHeader             = bit.bor(ImGuiTreeNodeFlags_Framed, ImGuiTreeNodeFlags_NoTreePushOnOpen, ImGuiTreeNodeFlags_NoAutoOpenOnLog);

--[[
* Gui Popup Flags
--]]

ImGuiPopupFlags_None                            = 0;
ImGuiPopupFlags_MouseButtonLeft                 = 0;                -- For BeginPopupContext*(): open on Left Mouse release. Guaranteed to always be == 0 (same as ImGuiMouseButton_Left)
ImGuiPopupFlags_MouseButtonRight                = 1;                -- For BeginPopupContext*(): open on Right Mouse release. Guaranteed to always be == 1 (same as ImGuiMouseButton_Right)
ImGuiPopupFlags_MouseButtonMiddle               = 2;                -- For BeginPopupContext*(): open on Middle Mouse release. Guaranteed to always be == 2 (same as ImGuiMouseButton_Middle)
ImGuiPopupFlags_MouseButtonMask_                = 0x1F;
ImGuiPopupFlags_MouseButtonDefault_             = 1;
ImGuiPopupFlags_NoOpenOverExistingPopup         = bit.lshift(1, 5); -- For OpenPopup*(), BeginPopupContext*(): don't open if there's already a popup at the same level of the popup stack
ImGuiPopupFlags_NoOpenOverItems                 = bit.lshift(1, 6); -- For BeginPopupContextWindow(): don't return true when hovering items, only when hovering empty space
ImGuiPopupFlags_AnyPopupId                      = bit.lshift(1, 7); -- For IsPopupOpen(): ignore the ImGuiID parameter and test for any popup.
ImGuiPopupFlags_AnyPopupLevel                   = bit.lshift(1, 8); -- For IsPopupOpen(): search/test at any level of the popup stack (default test in the current level)
ImGuiPopupFlags_AnyPopup                        = bit.bor(ImGuiPopupFlags_AnyPopupId, ImGuiPopupFlags_AnyPopupLevel);

--[[
* Gui Selectable Flags
--]]

ImGuiSelectableFlags_None                       = 0;
ImGuiSelectableFlags_DontClosePopups            = bit.lshift(1, 0); -- Clicking this don't close parent popup window
ImGuiSelectableFlags_SpanAllColumns             = bit.lshift(1, 1); -- Selectable frame can span all columns (text will still fit in current column)
ImGuiSelectableFlags_AllowDoubleClick           = bit.lshift(1, 2); -- Generate press events on double clicks too
ImGuiSelectableFlags_Disabled                   = bit.lshift(1, 3); -- Cannot be selected, display grayed out text
ImGuiSelectableFlags_AllowItemOverlap           = bit.lshift(1, 4); -- (WIP) Hit testing to allow subsequent widgets to overlap this one

--[[
* Gui Combo Flags
--]]

ImGuiComboFlags_None                            = 0;
ImGuiComboFlags_PopupAlignLeft                  = bit.lshift(1, 0); -- Align the popup toward the left by default
ImGuiComboFlags_HeightSmall                     = bit.lshift(1, 1); -- Max ~4 items visible. Tip: If you want your combo popup to be a specific size you can use SetNextWindowSizeConstraints() prior to calling BeginCombo()
ImGuiComboFlags_HeightRegular                   = bit.lshift(1, 2); -- Max ~8 items visible (default)
ImGuiComboFlags_HeightLarge                     = bit.lshift(1, 3); -- Max ~20 items visible
ImGuiComboFlags_HeightLargest                   = bit.lshift(1, 4); -- As many fitting items as possible
ImGuiComboFlags_NoArrowButton                   = bit.lshift(1, 5); -- Display on the preview box without the square arrow button
ImGuiComboFlags_NoPreview                       = bit.lshift(1, 6); -- Display only a square arrow button
ImGuiComboFlags_HeightMask_                     = bit.bor(ImGuiComboFlags_HeightSmall, ImGuiComboFlags_HeightRegular, ImGuiComboFlags_HeightLarge, ImGuiComboFlags_HeightLargest);

--[[
* Gui Tab Bar Flags
--]]

ImGuiTabBarFlags_None                           = 0;
ImGuiTabBarFlags_Reorderable                    = bit.lshift(1, 0); -- Allow manually dragging tabs to re-order them + New tabs are appended at the end of list
ImGuiTabBarFlags_AutoSelectNewTabs              = bit.lshift(1, 1); -- Automatically select new tabs when they appear
ImGuiTabBarFlags_TabListPopupButton             = bit.lshift(1, 2); -- Disable buttons to open the tab list popup
ImGuiTabBarFlags_NoCloseWithMiddleMouseButton   = bit.lshift(1, 3); -- Disable behavior of closing tabs (that are submitted with p_open != NULL) with middle mouse button. You can still repro this behavior on user's side with if (IsItemHovered() && IsMouseClicked(2)) *p_open = false.
ImGuiTabBarFlags_NoTabListScrollingButtons      = bit.lshift(1, 4); -- Disable scrolling buttons (apply when fitting policy is ImGuiTabBarFlags_FittingPolicyScroll)
ImGuiTabBarFlags_NoTooltip                      = bit.lshift(1, 5); -- Disable tooltips when hovering a tab
ImGuiTabBarFlags_FittingPolicyResizeDown        = bit.lshift(1, 6); -- Resize tabs when they don't fit
ImGuiTabBarFlags_FittingPolicyScroll            = bit.lshift(1, 7); -- Add scroll buttons when tabs don't fit
ImGuiTabBarFlags_FittingPolicyMask_             = bit.bor(ImGuiTabBarFlags_FittingPolicyResizeDown, ImGuiTabBarFlags_FittingPolicyScroll);
ImGuiTabBarFlags_FittingPolicyDefault_          = ImGuiTabBarFlags_FittingPolicyResizeDown;

--[[
* Gui Tab Item Flags
--]]

ImGuiTabItemFlags_None                          = 0;
ImGuiTabItemFlags_UnsavedDocument               = bit.lshift(1, 0); -- Append '*' to title without affecting the ID, as a convenience to avoid using the ### operator. Also: tab is selected on closure and closure is deferred by one frame to allow code to undo it without flicker.
ImGuiTabItemFlags_SetSelected                   = bit.lshift(1, 1); -- Trigger flag to programmatically make the tab selected when calling BeginTabItem()
ImGuiTabItemFlags_NoCloseWithMiddleMouseButton  = bit.lshift(1, 2); -- Disable behavior of closing tabs (that are submitted with p_open != NULL) with middle mouse button. You can still repro this behavior on user's side with if (IsItemHovered() && IsMouseClicked(2)) *p_open = false.
ImGuiTabItemFlags_NoPushId                      = bit.lshift(1, 3); -- Don't call PushID(tab->ID)/PopID() on BeginTabItem()/EndTabItem()
ImGuiTabItemFlags_NoTooltip                     = bit.lshift(1, 4); -- Disable tooltip for the given tab
ImGuiTabItemFlags_NoReorder                     = bit.lshift(1, 5); -- Disable reordering this tab or having another tab cross over this tab
ImGuiTabItemFlags_Leading                       = bit.lshift(1, 6); -- Enforce the tab position to the left of the tab bar (after the tab list popup button)
ImGuiTabItemFlags_Trailing                      = bit.lshift(1, 7); -- Enforce the tab position to the right of the tab bar (before the scrolling buttons)

--[[
* Gui Table Flags
--]]

-- Features
ImGuiTableFlags_None                            = 0;
ImGuiTableFlags_Resizable                       = bit.lshift(1, 0);  -- Enable resizing columns.
ImGuiTableFlags_Reorderable                     = bit.lshift(1, 1);  -- Enable reordering columns in header row (need calling TableSetupColumn() + TableHeadersRow() to display headers)
ImGuiTableFlags_Hideable                        = bit.lshift(1, 2);  -- Enable hiding/disabling columns in context menu.
ImGuiTableFlags_Sortable                        = bit.lshift(1, 3);  -- Enable sorting. Call TableGetSortSpecs() to obtain sort specs. Also see ImGuiTableFlags_SortMulti and ImGuiTableFlags_SortTristate.
ImGuiTableFlags_NoSavedSettings                 = bit.lshift(1, 4);  -- Disable persisting columns order, width and sort settings in the .ini file.
ImGuiTableFlags_ContextMenuInBody               = bit.lshift(1, 5);  -- Right-click on columns body/contents will display table context menu. By default it is available in TableHeadersRow().
-- Decorations
ImGuiTableFlags_RowBg                           = bit.lshift(1, 6);  -- Set each RowBg color with ImGuiCol_TableRowBg or ImGuiCol_TableRowBgAlt (equivalent of calling TableSetBgColor with ImGuiTableBgFlags_RowBg0 on each row manually)
ImGuiTableFlags_BordersInnerH                   = bit.lshift(1, 7);  -- Draw horizontal borders between rows.
ImGuiTableFlags_BordersOuterH                   = bit.lshift(1, 8);  -- Draw horizontal borders at the top and bottom.
ImGuiTableFlags_BordersInnerV                   = bit.lshift(1, 9);  -- Draw vertical borders between columns.
ImGuiTableFlags_BordersOuterV                   = bit.lshift(1, 10); -- Draw vertical borders on the left and right sides.
ImGuiTableFlags_BordersH                        = bit.bor(ImGuiTableFlags_BordersInnerH, ImGuiTableFlags_BordersOuterH); -- Draw horizontal borders.
ImGuiTableFlags_BordersV                        = bit.bor(ImGuiTableFlags_BordersInnerV, ImGuiTableFlags_BordersOuterV); -- Draw vertical borders.
ImGuiTableFlags_BordersInner                    = bit.bor(ImGuiTableFlags_BordersInnerV, ImGuiTableFlags_BordersInnerH); -- Draw inner borders.
ImGuiTableFlags_BordersOuter                    = bit.bor(ImGuiTableFlags_BordersOuterV, ImGuiTableFlags_BordersOuterH); -- Draw outer borders.
ImGuiTableFlags_Borders                         = bit.bor(ImGuiTableFlags_BordersInner, ImGuiTableFlags_BordersOuter);   -- Draw all borders.
ImGuiTableFlags_NoBordersInBody                 = bit.lshift(1, 11); -- [ALPHA] Disable vertical borders in columns Body (borders will always appears in Headers). -> May move to style
ImGuiTableFlags_NoBordersInBodyUntilResize      = bit.lshift(1, 12); -- [ALPHA] Disable vertical borders in columns Body until hovered for resize (borders will always appears in Headers). -> May move to style
-- Sizing Policy (read above for defaults)
ImGuiTableFlags_SizingFixedFit                  = bit.lshift(1, 13); -- Columns default to _WidthFixed or _WidthAuto (if resizable or not resizable), matching contents width.
ImGuiTableFlags_SizingFixedSame                 = bit.lshift(2, 13); -- Columns default to _WidthFixed or _WidthAuto (if resizable or not resizable), matching the maximum contents width of all columns. Implicitly enable ImGuiTableFlags_NoKeepColumnsVisible.
ImGuiTableFlags_SizingStretchProp               = bit.lshift(3, 13); -- Columns default to _WidthStretch with default weights proportional to each columns contents widths.
ImGuiTableFlags_SizingStretchSame               = bit.lshift(4, 13); -- Columns default to _WidthStretch with default weights all equal, unless overriden by TableSetupColumn().
-- Sizing Extra Options
ImGuiTableFlags_NoHostExtendX                   = bit.lshift(1, 16); -- Make outer width auto-fit to columns, overriding outer_size.x value. Only available when ScrollX/ScrollY are disabled and Stretch columns are not used.
ImGuiTableFlags_NoHostExtendY                   = bit.lshift(1, 17); -- Make outer height stop exactly at outer_size.y (prevent auto-extending table past the limit). Only available when ScrollX/ScrollY are disabled. Data below the limit will be clipped and not visible.
ImGuiTableFlags_NoKeepColumnsVisible            = bit.lshift(1, 18); -- Disable keeping column always minimally visible when ScrollX is off and table gets too small. Not recommended if columns are resizable.
ImGuiTableFlags_PreciseWidths                   = bit.lshift(1, 19); -- Disable distributing remainder width to stretched columns (width allocation on a 100-wide table with 3 columns: Without this flag: 33,33,34. With this flag: 33,33,33). With larger number of columns, resizing will appear to be less smooth.
-- Clipping
ImGuiTableFlags_NoClip                          = bit.lshift(1, 20); -- Disable clipping rectangle for every individual columns (reduce draw command count, items will be able to overflow into other columns). Generally incompatible with TableSetupScrollFreeze().
-- Padding
ImGuiTableFlags_PadOuterX                       = bit.lshift(1, 21); -- Default if BordersOuterV is on. Enable outer-most padding. Generally desirable if you have headers.
ImGuiTableFlags_NoPadOuterX                     = bit.lshift(1, 22); -- Default if BordersOuterV is off. Disable outer-most padding.
ImGuiTableFlags_NoPadInnerX                     = bit.lshift(1, 23); -- Disable inner padding between columns (double inner padding if BordersOuterV is on, single inner padding if BordersOuterV is off).
-- Scrolling
ImGuiTableFlags_ScrollX                         = bit.lshift(1, 24); -- Enable horizontal scrolling. Require 'outer_size' parameter of BeginTable() to specify the container size. Changes default sizing policy. Because this create a child window, ScrollY is currently generally recommended when using ScrollX.
ImGuiTableFlags_ScrollY                         = bit.lshift(1, 25); -- Enable vertical scrolling. Require 'outer_size' parameter of BeginTable() to specify the container size.
-- Sorting
ImGuiTableFlags_SortMulti                       = bit.lshift(1, 26); -- Hold shift when clicking headers to sort on multiple column. TableGetSortSpecs() may return specs where (SpecsCount > 1).
ImGuiTableFlags_SortTristate                    = bit.lshift(1, 27); -- Allow no sorting, disable default sorting. TableGetSortSpecs() may return specs where (SpecsCount == 0).
-- [Internal] Combinations and masks
ImGuiTableFlags_SizingMask_                     = bit.bor(ImGuiTableFlags_SizingFixedFit, ImGuiTableFlags_SizingFixedSame, ImGuiTableFlags_SizingStretchProp, ImGuiTableFlags_SizingStretchSame);

--[[
* Gui Table Column Flags
--]]

-- Input configuration flags
ImGuiTableColumnFlags_None                      = 0;
ImGuiTableColumnFlags_DefaultHide               = bit.lshift(1, 0);  -- Default as a hidden/disabled column.
ImGuiTableColumnFlags_DefaultSort               = bit.lshift(1, 1);  -- Default as a sorting column.
ImGuiTableColumnFlags_WidthStretch              = bit.lshift(1, 2);  -- Column will stretch. Preferable with horizontal scrolling disabled (default if table sizing policy is _SizingStretchSame or _SizingStretchProp).
ImGuiTableColumnFlags_WidthFixed                = bit.lshift(1, 3);  -- Column will not stretch. Preferable with horizontal scrolling enabled (default if table sizing policy is _SizingFixedFit and table is resizable).
ImGuiTableColumnFlags_NoResize                  = bit.lshift(1, 4);  -- Disable manual resizing.
ImGuiTableColumnFlags_NoReorder                 = bit.lshift(1, 5);  -- Disable manual reordering this column, this will also prevent other columns from crossing over this column.
ImGuiTableColumnFlags_NoHide                    = bit.lshift(1, 6);  -- Disable ability to hide/disable this column.
ImGuiTableColumnFlags_NoClip                    = bit.lshift(1, 7);  -- Disable clipping for this column (all NoClip columns will render in a same draw command).
ImGuiTableColumnFlags_NoSort                    = bit.lshift(1, 8);  -- Disable ability to sort on this field (even if ImGuiTableFlags_Sortable is set on the table).
ImGuiTableColumnFlags_NoSortAscending           = bit.lshift(1, 9);  -- Disable ability to sort in the ascending direction.
ImGuiTableColumnFlags_NoSortDescending          = bit.lshift(1, 10); -- Disable ability to sort in the descending direction.
ImGuiTableColumnFlags_NoHeaderWidth             = bit.lshift(1, 11); -- Disable header text width contribution to automatic column width.
ImGuiTableColumnFlags_PreferSortAscending       = bit.lshift(1, 12); -- Make the initial sort direction Ascending when first sorting on this column (default).
ImGuiTableColumnFlags_PreferSortDescending      = bit.lshift(1, 13); -- Make the initial sort direction Descending when first sorting on this column.
ImGuiTableColumnFlags_IndentEnable              = bit.lshift(1, 14); -- Use current Indent value when entering cell (default for column 0).
ImGuiTableColumnFlags_IndentDisable             = bit.lshift(1, 15); -- Ignore current Indent value when entering cell (default for columns > 0). Indentation changes _within_ the cell will still be honored.
-- Output status flags, read-only via TableGetColumnFlags()
ImGuiTableColumnFlags_IsEnabled                 = bit.lshift(1, 20); -- Status: is enabled == not hidden by user/api (referred to as "Hide" in _DefaultHide and _NoHide) flags.
ImGuiTableColumnFlags_IsVisible                 = bit.lshift(1, 21); -- Status: is visible == is enabled AND not clipped by scrolling.
ImGuiTableColumnFlags_IsSorted                  = bit.lshift(1, 22); -- Status: is currently part of the sort specs
ImGuiTableColumnFlags_IsHovered                 = bit.lshift(1, 23); -- Status: is hovered by mouse
-- [Internal] Combinations and masks
ImGuiTableColumnFlags_WidthMask_                = bit.bor(ImGuiTableColumnFlags_WidthStretch, ImGuiTableColumnFlags_WidthFixed);
ImGuiTableColumnFlags_IndentMask_               = bit.bor(ImGuiTableColumnFlags_IndentEnable, ImGuiTableColumnFlags_IndentDisable);
ImGuiTableColumnFlags_StatusMask_               = bit.bor(ImGuiTableColumnFlags_IsEnabled, ImGuiTableColumnFlags_IsVisible, ImGuiTableColumnFlags_IsSorted, ImGuiTableColumnFlags_IsHovered);
ImGuiTableColumnFlags_NoDirectResize_           = bit.lshift(1, 30); -- [Internal] Disable user resizing this column directly (it may however we resized indirectly from its left edge)

--[[
* Gui Table Row Flags
--]]

ImGuiTableRowFlags_None                         = 0;
ImGuiTableRowFlags_Headers                      = bit.lshift(1, 0); -- Identify header row (set default background color + width of its contents accounted different for auto column width)

--[[
* Gui Table Bg Target Flags
--]]

ImGuiTableBgTarget_None                         = 0;
ImGuiTableBgTarget_RowBg0                       = 1; -- Set row background color 0 (generally used for background, automatically set when ImGuiTableFlags_RowBg is used)
ImGuiTableBgTarget_RowBg1                       = 2; -- Set row background color 1 (generally used for selection marking)
ImGuiTableBgTarget_CellBg                       = 3; -- Set cell background color (top-most color)

--[[
* Gui Focused Flags
--]]

ImGuiFocusedFlags_None                          = 0;
ImGuiFocusedFlags_ChildWindows                  = bit.lshift(1, 0); -- IsWindowFocused(): Return true if any children of the window is focused
ImGuiFocusedFlags_RootWindow                    = bit.lshift(1, 1); -- IsWindowFocused(): Test from root window (top most parent of the current hierarchy)
ImGuiFocusedFlags_AnyWindow                     = bit.lshift(1, 2); -- IsWindowFocused(): Return true if any window is focused. Important: If you are trying to tell how to dispatch your low-level inputs, do NOT use this. Use 'io.WantCaptureMouse' instead! Please read the FAQ!
ImGuiFocusedFlags_RootAndChildWindows           = bit.bor(ImGuiFocusedFlags_RootWindow, ImGuiFocusedFlags_ChildWindows);

--[[
* Gui Hovered Flags
--]]

ImGuiHoveredFlags_None                          = 0;                -- Return true if directly over the item/window, not obstructed by another window, not obstructed by an active popup or modal blocking inputs under them.
ImGuiHoveredFlags_ChildWindows                  = bit.lshift(1, 0); -- IsWindowHovered() only: Return true if any children of the window is hovered
ImGuiHoveredFlags_RootWindow                    = bit.lshift(1, 1); -- IsWindowHovered() only: Test from root window (top most parent of the current hierarchy)
ImGuiHoveredFlags_AnyWindow                     = bit.lshift(1, 2); -- IsWindowHovered() only: Return true if any window is hovered
ImGuiHoveredFlags_AllowWhenBlockedByPopup       = bit.lshift(1, 3); -- Return true even if a popup window is normally blocking access to this item/window
--ImGuiHoveredFlags_AllowWhenBlockedByModal     = bit.lshift(1, 4); -- Return true even if a modal popup window is normally blocking access to this item/window. FIXME-TODO: Unavailable yet.
ImGuiHoveredFlags_AllowWhenBlockedByActiveItem  = bit.lshift(1, 5); -- Return true even if an active item is blocking access to this item/window. Useful for Drag and Drop patterns.
ImGuiHoveredFlags_AllowWhenOverlapped           = bit.lshift(1, 6); -- Return true even if the position is obstructed or overlapped by another window
ImGuiHoveredFlags_AllowWhenDisabled             = bit.lshift(1, 7); -- Return true even if the item is disabled
ImGuiHoveredFlags_RectOnly                      = bit.bor(ImGuiHoveredFlags_AllowWhenBlockedByPopup, ImGuiHoveredFlags_AllowWhenBlockedByActiveItem, ImGuiHoveredFlags_AllowWhenOverlapped);
ImGuiHoveredFlags_RootAndChildWindows           = bit.bor(ImGuiHoveredFlags_RootWindow, ImGuiHoveredFlags_ChildWindows);

--[[
* Gui Drag Drop Flags
--]]

ImGuiDragDropFlags_None                         = 0;
-- BeginDragDropSource() flags
ImGuiDragDropFlags_SourceNoPreviewTooltip       = bit.lshift(1, 0);     -- By default, a successful call to BeginDragDropSource opens a tooltip so you can display a preview or description of the source contents. This flag disable this behavior.
ImGuiDragDropFlags_SourceNoDisableHover         = bit.lshift(1, 1);     -- By default, when dragging we clear data so that IsItemHovered() will return false, to avoid subsequent user code submitting tooltips. This flag disable this behavior so you can still call IsItemHovered() on the source item.
ImGuiDragDropFlags_SourceNoHoldToOpenOthers     = bit.lshift(1, 2);     -- Disable the behavior that allows to open tree nodes and collapsing header by holding over them while dragging a source item.
ImGuiDragDropFlags_SourceAllowNullID            = bit.lshift(1, 3);     -- Allow items such as Text(), Image() that have no unique identifier to be used as drag source, by manufacturing a temporary identifier based on their window-relative position. This is extremely unusual within the dear imgui ecosystem and so we made it explicit.
ImGuiDragDropFlags_SourceExtern                 = bit.lshift(1, 4);     -- External source (from outside of dear imgui), won't attempt to read current item/window info. Will always return true. Only one Extern source can be active simultaneously.
ImGuiDragDropFlags_SourceAutoExpirePayload      = bit.lshift(1, 5);     -- Automatically expire the payload if the source cease to be submitted (otherwise payloads are persisting while being dragged)
-- AcceptDragDropPayload() flags
ImGuiDragDropFlags_AcceptBeforeDelivery         = bit.lshift(1, 10);    -- AcceptDragDropPayload() will returns true even before the mouse button is released. You can then call IsDelivery() to test if the payload needs to be delivered.
ImGuiDragDropFlags_AcceptNoDrawDefaultRect      = bit.lshift(1, 11);    -- Do not draw the default highlight rectangle when hovering over target.
ImGuiDragDropFlags_AcceptNoPreviewTooltip       = bit.lshift(1, 12);    -- Request hiding the BeginDragDropSource tooltip from the BeginDragDropTarget site.
ImGuiDragDropFlags_AcceptPeekOnly               = bit.bor(ImGuiDragDropFlags_AcceptBeforeDelivery, ImGuiDragDropFlags_AcceptNoDrawDefaultRect); -- For peeking ahead and inspecting the payload before delivery.

--[[
* Gui Drag Drop Payload Types
--]]

IMGUI_PAYLOAD_TYPE_COLOR_3F                     = '_COL3F'; -- float[3]: Standard type for colors, without alpha. User code may use this type.
IMGUI_PAYLOAD_TYPE_COLOR_4F                     = '_COL4F'; -- float[4]: Standard type for colors. User code may use this type.

--[[
* Gui Data Types
--]]

ImGuiDataType_S8                                = 0; -- signed char / char (with sensible compilers)
ImGuiDataType_U8                                = 1; -- unsigned char
ImGuiDataType_S16                               = 2; -- short
ImGuiDataType_U16                               = 3; -- unsigned short
ImGuiDataType_S32                               = 4; -- int
ImGuiDataType_U32                               = 5; -- unsigned int
ImGuiDataType_S64                               = 6; -- long long / __int64
ImGuiDataType_U64                               = 7; -- unsigned long long / unsigned __int64
ImGuiDataType_Float                             = 8; -- float
ImGuiDataType_Double                            = 9; -- double
ImGuiDataType_COUNT                             = 10;

--[[
* Gui Dir Types
--]]

ImGuiDir_None                                   = -1;
ImGuiDir_Left                                   = 0;
ImGuiDir_Right                                  = 1;
ImGuiDir_Up                                     = 2;
ImGuiDir_Down                                   = 3;
ImGuiDir_COUNT                                  = 4;

--[[
* Gui Sort Directions
--]]

ImGuiSortDirection_None                         = 0;
ImGuiSortDirection_Ascending                    = 1; -- Ascending = 0->9, A->Z etc.
ImGuiSortDirection_Descending                   = 2; -- Descending = 9->0, Z->A etc.

--[[
* Gui Keys
--]]

ImGuiKey_Tab                                    = 0;
ImGuiKey_LeftArrow                              = 1;
ImGuiKey_RightArrow                             = 2;
ImGuiKey_UpArrow                                = 3;
ImGuiKey_DownArrow                              = 4;
ImGuiKey_PageUp                                 = 5;
ImGuiKey_PageDown                               = 6;
ImGuiKey_Home                                   = 7;
ImGuiKey_End                                    = 8;
ImGuiKey_Insert                                 = 9;
ImGuiKey_Delete                                 = 10;
ImGuiKey_Backspace                              = 11;
ImGuiKey_Space                                  = 12;
ImGuiKey_Enter                                  = 13;
ImGuiKey_Escape                                 = 14;
ImGuiKey_KeyPadEnter                            = 15;
ImGuiKey_A                                      = 16; -- for text edit CTRL+A: select all
ImGuiKey_C                                      = 17; -- for text edit CTRL+C: copy
ImGuiKey_V                                      = 18; -- for text edit CTRL+V: paste
ImGuiKey_X                                      = 19; -- for text edit CTRL+X: cut
ImGuiKey_Y                                      = 20; -- for text edit CTRL+Y: redo
ImGuiKey_Z                                      = 21; -- for text edit CTRL+Z: undo
ImGuiKey_COUNT                                  = 22;

--[[
* Gui Key Mod Flags
--]]

ImGuiKeyModFlags_None                           = 0;
ImGuiKeyModFlags_Ctrl                           = bit.lshift(1, 0);
ImGuiKeyModFlags_Shift                          = bit.lshift(1, 1);
ImGuiKeyModFlags_Alt                            = bit.lshift(1, 2);
ImGuiKeyModFlags_Super                          = bit.lshift(1, 3);

--[[
* Gui Nav Input Flags
--]]

-- Gamepad Mapping
ImGuiNavInput_Activate                          = 0;    -- activate / open / toggle / tweak value       // e.g. Cross  (PS4), A (Xbox), A (Switch), Space (Keyboard)
ImGuiNavInput_Cancel                            = 1;    -- cancel / close / exit                        // e.g. Circle (PS4), B (Xbox), B (Switch), Escape (Keyboard)
ImGuiNavInput_Input                             = 2;    -- text input / on-screen keyboard              // e.g. Triang.(PS4), Y (Xbox), X (Switch), Return (Keyboard)
ImGuiNavInput_Menu                              = 3;    -- tap: toggle menu / hold: focus, move, resize // e.g. Square (PS4), X (Xbox), Y (Switch), Alt (Keyboard)
ImGuiNavInput_DpadLeft                          = 4;    -- move / tweak / resize window (w/ PadMenu)    // e.g. D-pad Left/Right/Up/Down (Gamepads), Arrow keys (Keyboard)
ImGuiNavInput_DpadRight                         = 5;    --
ImGuiNavInput_DpadUp                            = 6;    --
ImGuiNavInput_DpadDown                          = 7;    --
ImGuiNavInput_LStickLeft                        = 8;    -- scroll / move window (w/ PadMenu)            // e.g. Left Analog Stick Left/Right/Up/Down
ImGuiNavInput_LStickRight                       = 9;    --
ImGuiNavInput_LStickUp                          = 10;   --
ImGuiNavInput_LStickDown                        = 11;   --
ImGuiNavInput_FocusPrev                         = 12;   -- next window (w/ PadMenu)                     // e.g. L1 or L2 (PS4), LB or LT (Xbox), L or ZL (Switch)
ImGuiNavInput_FocusNext                         = 13;   -- prev window (w/ PadMenu)                     // e.g. R1 or R2 (PS4), RB or RT (Xbox), R or ZL (Switch)
ImGuiNavInput_TweakSlow                         = 14;   -- slower tweaks                                // e.g. L1 or L2 (PS4), LB or LT (Xbox), L or ZL (Switch)
ImGuiNavInput_TweakFast                         = 15;   -- faster tweaks                                // e.g. R1 or R2 (PS4), RB or RT (Xbox), R or ZL (Switch)
-- [Internal] Don't use directly! This is used internally to differentiate keyboard from gamepad inputs for behaviors that require to differentiate them.
-- Keyboard behavior that have no corresponding gamepad mapping (e.g. CTRL+TAB) will be directly reading from io.KeysDown[] instead of io.NavInputs[].
ImGuiNavInput_KeyMenu_                          = 16;   -- toggle menu                                  // = io.KeyAlt
ImGuiNavInput_KeyLeft_                          = 17;   -- move left                                    // = Arrow keys
ImGuiNavInput_KeyRight_                         = 18;   -- move right
ImGuiNavInput_KeyUp_                            = 19;   -- move up
ImGuiNavInput_KeyDown_                          = 20;   -- move down
ImGuiNavInput_COUNT                             = 21;
ImGuiNavInput_InternalStart_                    = ImGuiNavInput_KeyMenu_;

--[[
* Gui Config Flags
--]]

ImGuiConfigFlags_None                           = 0;
ImGuiConfigFlags_NavEnableKeyboard              = bit.lshift(1, 0);     -- Master keyboard navigation enable flag. NewFrame() will automatically fill io.NavInputs[] based on io.KeysDown[].
ImGuiConfigFlags_NavEnableGamepad               = bit.lshift(1, 1);     -- Master gamepad navigation enable flag. This is mostly to instruct your imgui backend to fill io.NavInputs[]. Backend also needs to set ImGuiBackendFlags_HasGamepad.
ImGuiConfigFlags_NavEnableSetMousePos           = bit.lshift(1, 2);     -- Instruct navigation to move the mouse cursor. May be useful on TV/console systems where moving a virtual mouse is awkward. Will update io.MousePos and set io.WantSetMousePos=true. If enabled you MUST honor io.WantSetMousePos requests in your backend, otherwise ImGui will react as if the mouse is jumping around back and forth.
ImGuiConfigFlags_NavNoCaptureKeyboard           = bit.lshift(1, 3);     -- Instruct navigation to not set the io.WantCaptureKeyboard flag when io.NavActive is set.
ImGuiConfigFlags_NoMouse                        = bit.lshift(1, 4);     -- Instruct imgui to clear mouse position/buttons in NewFrame(). This allows ignoring the mouse information set by the backend.
ImGuiConfigFlags_NoMouseCursorChange            = bit.lshift(1, 5);     -- Instruct backend to not alter mouse cursor shape and visibility. Use if the backend cursor changes are interfering with yours and you don't want to use SetMouseCursor() to change mouse cursor. You may want to honor requests from imgui by reading GetMouseCursor() yourself instead.
-- User storage (to allow your backend/engine to communicate to code that may be shared between multiple projects. Those flags are not used by core Dear ImGui)
ImGuiConfigFlags_IsSRGB                         = bit.lshift(1, 20);    -- Application is SRGB-aware.
ImGuiConfigFlags_IsTouchScreen                  = bit.lshift(1, 21);    -- Application is using a touch screen instead of a mouse.

--[[
* Gui Backend Flags
--]]

ImGuiBackendFlags_None                          = 0;
ImGuiBackendFlags_HasGamepad                    = bit.lshift(1, 0);     -- Backend Platform supports gamepad and currently has one connected.
ImGuiBackendFlags_HasMouseCursors               = bit.lshift(1, 1);     -- Backend Platform supports honoring GetMouseCursor() value to change the OS cursor shape.
ImGuiBackendFlags_HasSetMousePos                = bit.lshift(1, 2);     -- Backend Platform supports io.WantSetMousePos requests to reposition the OS mouse position (only used if ImGuiConfigFlags_NavEnableSetMousePos is set).
ImGuiBackendFlags_RendererHasVtxOffset          = bit.lshift(1, 3);     -- Backend Renderer supports ImDrawCmd::VtxOffset. This enables output of large meshes (64K+ vertices) while still using 16-bit indices.

--[[
* Gui Color Enum
--]]

ImGuiCol_Text                                   = 0;
ImGuiCol_TextDisabled                           = 1;
ImGuiCol_WindowBg                               = 2; -- Background of normal windows
ImGuiCol_ChildBg                                = 3; -- Background of child windows
ImGuiCol_PopupBg                                = 4; -- Background of popups, menus, tooltips windows
ImGuiCol_Border                                 = 5;
ImGuiCol_BorderShadow                           = 6;
ImGuiCol_FrameBg                                = 7; -- Background of checkbox, radio button, plot, slider, text input
ImGuiCol_FrameBgHovered                         = 8;
ImGuiCol_FrameBgActive                          = 9;
ImGuiCol_TitleBg                                = 10;
ImGuiCol_TitleBgActive                          = 11;
ImGuiCol_TitleBgCollapsed                       = 12;
ImGuiCol_MenuBarBg                              = 13;
ImGuiCol_ScrollbarBg                            = 14;
ImGuiCol_ScrollbarGrab                          = 15;
ImGuiCol_ScrollbarGrabHovered                   = 16;
ImGuiCol_ScrollbarGrabActive                    = 17;
ImGuiCol_CheckMark                              = 18;
ImGuiCol_SliderGrab                             = 19;
ImGuiCol_SliderGrabActive                       = 20;
ImGuiCol_Button                                 = 21;
ImGuiCol_ButtonHovered                          = 22;
ImGuiCol_ButtonActive                           = 23;
ImGuiCol_Header                                 = 24; -- Header* colors are used for CollapsingHeader, TreeNode, Selectable, MenuItem
ImGuiCol_HeaderHovered                          = 25;
ImGuiCol_HeaderActive                           = 26;
ImGuiCol_Separator                              = 27;
ImGuiCol_SeparatorHovered                       = 28;
ImGuiCol_SeparatorActive                        = 29;
ImGuiCol_ResizeGrip                             = 30;
ImGuiCol_ResizeGripHovered                      = 31;
ImGuiCol_ResizeGripActive                       = 32;
ImGuiCol_Tab                                    = 33;
ImGuiCol_TabHovered                             = 34;
ImGuiCol_TabActive                              = 35;
ImGuiCol_TabUnfocused                           = 36;
ImGuiCol_TabUnfocusedActive                     = 37;
ImGuiCol_PlotLines                              = 38;
ImGuiCol_PlotLinesHovered                       = 39;
ImGuiCol_PlotHistogram                          = 40;
ImGuiCol_PlotHistogramHovered                   = 41;
ImGuiCol_TableHeaderBg                          = 42; -- Table header background
ImGuiCol_TableBorderStrong                      = 43; -- Table outer and header borders (prefer using Alpha=1.0 here)
ImGuiCol_TableBorderLight                       = 44; -- Table inner borders (prefer using Alpha=1.0 here)
ImGuiCol_TableRowBg                             = 45; -- Table row background (even rows)
ImGuiCol_TableRowBgAlt                          = 46; -- Table row background (odd rows)
ImGuiCol_TextSelectedBg                         = 47;
ImGuiCol_DragDropTarget                         = 48;
ImGuiCol_NavHighlight                           = 49; -- Gamepad/keyboard: current highlighted item
ImGuiCol_NavWindowingHighlight                  = 50; -- Highlight window when using CTRL+TAB
ImGuiCol_NavWindowingDimBg                      = 51; -- Darken/colorize entire screen behind the CTRL+TAB window list, when active
ImGuiCol_ModalWindowDimBg                       = 52; -- Darken/colorize entire screen behind a modal window, when one is active
ImGuiCol_COUNT                                  = 53;

--[[
* Gui Style Var Enum
--]]

ImGuiStyleVar_Alpha                             = 0;    -- float     Alpha
ImGuiStyleVar_WindowPadding                     = 1;    -- ImVec2    WindowPadding
ImGuiStyleVar_WindowRounding                    = 2;    -- float     WindowRounding
ImGuiStyleVar_WindowBorderSize                  = 3;    -- float     WindowBorderSize
ImGuiStyleVar_WindowMinSize                     = 4;    -- ImVec2    WindowMinSize
ImGuiStyleVar_WindowTitleAlign                  = 5;    -- ImVec2    WindowTitleAlign
ImGuiStyleVar_ChildRounding                     = 6;    -- float     ChildRounding
ImGuiStyleVar_ChildBorderSize                   = 7;    -- float     ChildBorderSize
ImGuiStyleVar_PopupRounding                     = 8;    -- float     PopupRounding
ImGuiStyleVar_PopupBorderSize                   = 9;    -- float     PopupBorderSize
ImGuiStyleVar_FramePadding                      = 10;   -- ImVec2    FramePadding
ImGuiStyleVar_FrameRounding                     = 11;   -- float     FrameRounding
ImGuiStyleVar_FrameBorderSize                   = 12;   -- float     FrameBorderSize
ImGuiStyleVar_ItemSpacing                       = 13;   -- ImVec2    ItemSpacing
ImGuiStyleVar_ItemInnerSpacing                  = 14;   -- ImVec2    ItemInnerSpacing
ImGuiStyleVar_IndentSpacing                     = 15;   -- float     IndentSpacing
ImGuiStyleVar_CellPadding                       = 16;   -- ImVec2    CellPadding
ImGuiStyleVar_ScrollbarSize                     = 17;   -- float     ScrollbarSize
ImGuiStyleVar_ScrollbarRounding                 = 18;   -- float     ScrollbarRounding
ImGuiStyleVar_GrabMinSize                       = 19;   -- float     GrabMinSize
ImGuiStyleVar_GrabRounding                      = 20;   -- float     GrabRounding
ImGuiStyleVar_TabRounding                       = 21;   -- float     TabRounding
ImGuiStyleVar_ButtonTextAlign                   = 22;   -- ImVec2    ButtonTextAlign
ImGuiStyleVar_SelectableTextAlign               = 23;   -- ImVec2    SelectableTextAlign
ImGuiStyleVar_COUNT                             = 24;

--[[
* Gui Button Flags
--]]

ImGuiButtonFlags_None                           = 0;
ImGuiButtonFlags_MouseButtonLeft                = bit.lshift(1, 0); -- React on left mouse button (default)
ImGuiButtonFlags_MouseButtonRight               = bit.lshift(1, 1); -- React on right mouse button
ImGuiButtonFlags_MouseButtonMiddle              = bit.lshift(1, 2); -- React on center mouse button
-- [Internal]
ImGuiButtonFlags_MouseButtonMask_               = bit.bor(ImGuiButtonFlags_MouseButtonLeft, ImGuiButtonFlags_MouseButtonRight, ImGuiButtonFlags_MouseButtonMiddle);
ImGuiButtonFlags_MouseButtonDefault_            = ImGuiButtonFlags_MouseButtonLeft;

--[[
* Gui Color Edit Flags
--]]

ImGuiColorEditFlags_None                        = 0;
ImGuiColorEditFlags_NoAlpha                     = bit.lshift(1, 1);  -- ColorEdit, ColorPicker, ColorButton: ignore Alpha component (will only read 3 components from the input pointer).
ImGuiColorEditFlags_NoPicker                    = bit.lshift(1, 2);  -- ColorEdit: disable picker when clicking on color square.
ImGuiColorEditFlags_NoOptions                   = bit.lshift(1, 3);  -- ColorEdit: disable toggling options menu when right-clicking on inputs/small preview.
ImGuiColorEditFlags_NoSmallPreview              = bit.lshift(1, 4);  -- ColorEdit, ColorPicker: disable color square preview next to the inputs. (e.g. to show only the inputs)
ImGuiColorEditFlags_NoInputs                    = bit.lshift(1, 5);  -- ColorEdit, ColorPicker: disable inputs sliders/text widgets (e.g. to show only the small preview color square).
ImGuiColorEditFlags_NoTooltip                   = bit.lshift(1, 6);  -- ColorEdit, ColorPicker, ColorButton: disable tooltip when hovering the preview.
ImGuiColorEditFlags_NoLabel                     = bit.lshift(1, 7);  -- ColorEdit, ColorPicker: disable display of inline text label (the label is still forwarded to the tooltip and picker).
ImGuiColorEditFlags_NoSidePreview               = bit.lshift(1, 8);  -- ColorPicker: disable bigger color preview on right side of the picker, use small color square preview instead.
ImGuiColorEditFlags_NoDragDrop                  = bit.lshift(1, 9);  -- ColorEdit: disable drag and drop target. ColorButton: disable drag and drop source.
ImGuiColorEditFlags_NoBorder                    = bit.lshift(1, 10); -- ColorButton: disable border (which is enforced by default)
-- User Options (right-click on widget to change some of them).
ImGuiColorEditFlags_AlphaBar                    = bit.lshift(1, 16); --              // ColorEdit, ColorPicker: show vertical alpha bar/gradient in picker.
ImGuiColorEditFlags_AlphaPreview                = bit.lshift(1, 17); --              // ColorEdit, ColorPicker, ColorButton: display preview as a transparent color over a checkerboard, instead of opaque.
ImGuiColorEditFlags_AlphaPreviewHalf            = bit.lshift(1, 18); --              // ColorEdit, ColorPicker, ColorButton: display half opaque / half checkerboard, instead of opaque.
ImGuiColorEditFlags_HDR                         = bit.lshift(1, 19); --              // (WIP) ColorEdit: Currently only disable 0.0f..1.0f limits in RGBA edition (note: you probably want to use ImGuiColorEditFlags_Float flag as well).
ImGuiColorEditFlags_DisplayRGB                  = bit.lshift(1, 20); -- [Display]    // ColorEdit: override _display_ type among RGB/HSV/Hex. ColorPicker: select any combination using one or more of RGB/HSV/Hex.
ImGuiColorEditFlags_DisplayHSV                  = bit.lshift(1, 21); -- [Display]    // "
ImGuiColorEditFlags_DisplayHex                  = bit.lshift(1, 22); -- [Display]    // "
ImGuiColorEditFlags_Uint8                       = bit.lshift(1, 23); -- [DataType]   // ColorEdit, ColorPicker, ColorButton: _display_ values formatted as 0..255.
ImGuiColorEditFlags_Float                       = bit.lshift(1, 24); -- [DataType]   // ColorEdit, ColorPicker, ColorButton: _display_ values formatted as 0.0f..1.0f floats instead of 0..255 integers. No round-trip of value via integers.
ImGuiColorEditFlags_PickerHueBar                = bit.lshift(1, 25); -- [Picker]     // ColorPicker: bar for Hue, rectangle for Sat/Value.
ImGuiColorEditFlags_PickerHueWheel              = bit.lshift(1, 26); -- [Picker]     // ColorPicker: wheel for Hue, triangle for Sat/Value.
ImGuiColorEditFlags_InputRGB                    = bit.lshift(1, 27); -- [Input]      // ColorEdit, ColorPicker: input and output data in RGB format.
ImGuiColorEditFlags_InputHSV                    = bit.lshift(1, 28); -- [Input]      // ColorEdit, ColorPicker: input and output data in HSV format.
-- Defaults Options. You can set application defaults using SetColorEditOptions(). The intent is that you probably don't want to
-- override them in most of your calls. Let the user choose via the option menu and/or call SetColorEditOptions() once during startup.
ImGuiColorEditFlags__OptionsDefault             = bit.bor(ImGuiColorEditFlags_Uint8, ImGuiColorEditFlags_DisplayRGB, ImGuiColorEditFlags_InputRGB, ImGuiColorEditFlags_PickerHueBar);
-- [Internal] Masks
ImGuiColorEditFlags__DisplayMask                = bit.bor(ImGuiColorEditFlags_DisplayRGB, ImGuiColorEditFlags_DisplayHSV, ImGuiColorEditFlags_DisplayHex);
ImGuiColorEditFlags__DataTypeMask               = bit.bor(ImGuiColorEditFlags_Uint8, ImGuiColorEditFlags_Float);
ImGuiColorEditFlags__PickerMask                 = bit.bor(ImGuiColorEditFlags_PickerHueWheel, ImGuiColorEditFlags_PickerHueBar);
ImGuiColorEditFlags__InputMask                  = bit.bor(ImGuiColorEditFlags_InputRGB, ImGuiColorEditFlags_InputHSV);

--[[
* Gui Slider Flags
--]]

ImGuiSliderFlags_None                           = 0;
ImGuiSliderFlags_AlwaysClamp                    = bit.lshift(1, 4); -- Clamp value to min/max bounds when input manually with CTRL+Click. By default CTRL+Click allows going out of bounds.
ImGuiSliderFlags_Logarithmic                    = bit.lshift(1, 5); -- Make the widget logarithmic (linear otherwise). Consider using ImGuiSliderFlags_NoRoundToFormat with this if using a format-string with small amount of digits.
ImGuiSliderFlags_NoRoundToFormat                = bit.lshift(1, 6); -- Disable rounding underlying value to match precision of the display format string (e.g. %.3f values are rounded to those 3 digits)
ImGuiSliderFlags_NoInput                        = bit.lshift(1, 7); -- Disable CTRL+Click or Enter key allowing to input text directly into the widget
ImGuiSliderFlags_InvalidMask_                   = 0x7000000F;       -- [Internal] We treat using those bits as being potentially a 'float power' argument from the previous API that has got miscast to this enum, and will trigger an assert if needed.

--[[
* Gui Mouse Buttons Enum
--]]

ImGuiMouseButton_Left                           = 0;
ImGuiMouseButton_Right                          = 1;
ImGuiMouseButton_Middle                         = 2;
ImGuiMouseButton_COUNT                          = 5;

--[[
* Gui Mouse Cursor Enum
--]]

ImGuiMouseCursor_None                           = -1;
ImGuiMouseCursor_Arrow                          = 0;
ImGuiMouseCursor_TextInput                      = 1; -- When hovering over InputText, etc.
ImGuiMouseCursor_ResizeAll                      = 2; -- (Unused by Dear ImGui functions)
ImGuiMouseCursor_ResizeNS                       = 3; -- When hovering over an horizontal border
ImGuiMouseCursor_ResizeEW                       = 4; -- When hovering over a vertical border or a column
ImGuiMouseCursor_ResizeNESW                     = 5; -- When hovering over the bottom-left corner of a window
ImGuiMouseCursor_ResizeNWSE                     = 6; -- When hovering over the bottom-right corner of a window
ImGuiMouseCursor_Hand                           = 7; -- (Unused by Dear ImGui functions. Use for e.g. hyperlinks)
ImGuiMouseCursor_NotAllowed                     = 8; -- When hovering something with disallowed interaction. Usually a crossed circle.
ImGuiMouseCursor_COUNT                          = 9;

--[[
* Gui Condition Enum
--]]

ImGuiCond_None                                  = 0;                -- No condition (always set the variable), same as _Always
ImGuiCond_Always                                = bit.lshift(1, 0); -- No condition (always set the variable)
ImGuiCond_Once                                  = bit.lshift(1, 1); -- Set the variable once per runtime session (only the first call will succeed)
ImGuiCond_FirstUseEver                          = bit.lshift(1, 2); -- Set the variable if the object/window has no persistently saved data (no entry in .ini file)
ImGuiCond_Appearing                             = bit.lshift(1, 3); -- Set the variable if the object/window is appearing after being hidden/inactive (or the first time)

--[[
* Unicode Helper Defines
--]]

IM_UNICODE_CODEPOINT_INVALID                    = 0xFFFD;
IM_UNICODE_CODEPOINT_MAX                        = 0xFFFF;

--[[
* Color Encoding Helper Defines
--]]

IM_COL32_R_SHIFT                                = 0;
IM_COL32_G_SHIFT                                = 8;
IM_COL32_B_SHIFT                                = 16;
IM_COL32_A_SHIFT                                = 24;
IM_COL32_A_MASK                                 = 0xFF000000;

--[[
* Convert the given ARGB values into a 32bit color.
*
* @param {number} a - The alpha color code.
* @param {number} r - The red color code.
* @param {number} g - The green color code.
* @param {number} b - The blue color code.
* @return {number} The calculated ARGB value.
--]]
function imgui.col32(a, r, g, b)
    return bit.bor(bit.lshift(a, IM_COL32_A_SHIFT), bit.lshift(b, IM_COL32_B_SHIFT), bit.lshift(g, IM_COL32_G_SHIFT), bit.lshift(r, IM_COL32_R_SHIFT));
end

IM_COL32_WHITE                                  = imgui.col32(255, 255, 255, 255);
IM_COL32_BLACK                                  = imgui.col32(0, 0, 0, 255);
IM_COL32_BLACK_TRANS                            = imgui.col32(0, 0, 0, 0);

--[[
* Drawing Helper Defines
--]]

-- The maximum line width to bake anti-aliased textures for. Build atlas with ImFontAtlasFlags_NoBakedLines to disable baking.
IM_DRAWLIST_TEX_LINES_WIDTH_MAX                 = 63;

-- Special Draw callback value to request renderer backend to reset the graphics/render state.
ImDrawCallback_ResetRenderState                 = -1;

--[[
* Draw Corner Flags
--]]

ImDrawCornerFlags_None                          = 0;
ImDrawCornerFlags_TopLeft                       = bit.lshift(1, 0); -- 0x1
ImDrawCornerFlags_TopRight                      = bit.lshift(1, 1); -- 0x2
ImDrawCornerFlags_BotLeft                       = bit.lshift(1, 2); -- 0x4
ImDrawCornerFlags_BotRight                      = bit.lshift(1, 3); -- 0x8
ImDrawCornerFlags_Top                           = bit.bor(ImDrawCornerFlags_TopLeft, ImDrawCornerFlags_TopRight);   -- 0x3
ImDrawCornerFlags_Bot                           = bit.bor(ImDrawCornerFlags_BotLeft, ImDrawCornerFlags_BotRight);   -- 0xC
ImDrawCornerFlags_Left                          = bit.bor(ImDrawCornerFlags_TopLeft, ImDrawCornerFlags_BotLeft);    -- 0x5
ImDrawCornerFlags_Right                         = bit.bor(ImDrawCornerFlags_TopRight, ImDrawCornerFlags_BotRight);  -- 0xA
ImDrawCornerFlags_All                           = 0xF; -- In your function calls you may use ~0 (= all bits sets) instead of ImDrawCornerFlags_All, as a convenience

--[[
* Draw List Flags
--]]

ImDrawListFlags_None                            = 0;
ImDrawListFlags_AntiAliasedLines                = bit.lshift(1, 0);  -- Enable anti-aliased lines/borders (*2 the number of triangles for 1.0f wide line or lines thin enough to be drawn using textures, otherwise *3 the number of triangles)
ImDrawListFlags_AntiAliasedLinesUseTex          = bit.lshift(1, 1);  -- Enable anti-aliased lines/borders using textures when possible. Require backend to render with bilinear filtering.
ImDrawListFlags_AntiAliasedFill                 = bit.lshift(1, 2);  -- Enable anti-aliased edge around filled shapes (rounded rectangles, circles).
ImDrawListFlags_AllowVtxOffset                  = bit.lshift(1, 3);  -- Can emit 'VtxOffset > 0' to allow large meshes. Set when 'ImGuiBackendFlags_RendererHasVtxOffset' is enabled.

--[[
* Font Atlas Flags
--]]

ImFontAtlasFlags_None                           = 0;
ImFontAtlasFlags_NoPowerOfTwoHeight             = bit.lshift(1, 0); -- Don't round the height to next power of two
ImFontAtlasFlags_NoMouseCursors                 = bit.lshift(1, 1); -- Don't build software mouse cursors into the atlas (save a little texture memory)
ImFontAtlasFlags_NoBakedLines                   = bit.lshift(1, 2); -- Don't build thick line textures into the atlas (save a little texture memory). The AntiAliasedLinesUseTex features uses them, otherwise they will be rendered using polygons (more expensive for CPU/GPU).

--[[
*
* Custom ImGui Helpers
*
--]]

--[[
* Draws an help marker with ImGui that will display some text when hovered over with the mouse.
*
* @param {string} text - The help string to display when hovered.
--]]
function imgui.ShowHelp(text, sameLine)
    sameLine = sameLine or true;
    if (sameLine) then
        imgui.SameLine();
    end

    imgui.TextDisabled('(?)');
    if (imgui.IsItemHovered()) then
        imgui.BeginTooltip();
            imgui.PushTextWrapPos(imgui.GetFontSize() * 35.0);
            imgui.TextUnformatted(text);
            imgui.PopTextWrapPos();
        imgui.EndTooltip();
    end
end

--[[
* Popup Button Flags
--]]
PopupButtonsOk            = 0;
PopupButtonsOkCancel      = 1;
PopupButtonsYesNo         = 2;
PopupButtonsYesNoCancel   = 3;

--[[
* Popup Return Results
--]]
PopupResultNone   = 0;
PopupResultOk     = 1;
PopupResultCancel = 2;
PopupResultYes    = 3;
PopupResultNo     = 4;

--[[
* Helper function that displays a popup if it is currently enabled to be displayed.
*
* @param {string} title - The title text of the popup.
* @param {string} name - The internal ImGui hashtag name of the popup.
* @param {function} cb - The callback function to call to render the popups contents.
* @param {number} buttons - The type of buttons to show on the popup. (See PopupButtons above.)
* @return {number} The popup result. (See PopupResult above.)
--]]
function imgui.DisplayPopup(title, name, cb, buttons)
    local res = PopupResultNone;

    -- Determine the window center for the popup..
    local size = imgui.GetIO().DisplaySize;
    local center = { size.x * 0.5, size.y * 0.5 };

    -- Setup the popup to be centered and resize to its contents..
    imgui.SetNextWindowPos(center, ImGuiCond_Appearing, { 0.5, 0.5 });
    imgui.SetNextWindowSize({ -1, -1 }, ImGuiCond_Always);

    -- Show the popup..
    if (imgui.BeginPopupModal(('%s###%s'):fmt(title, name), nil, ImGuiWindowFlags_AlwaysAutoResize)) then
        -- Render the inner-contents of the popup..
        pcall(function () cb(); end);

        -- Render the popup buttons..
        switch(buttons, {
            [PopupButtonsOk] = function ()
                if (imgui.Button('Ok', { 120, 0 })) then
                    imgui.CloseCurrentPopup();
                    res = PopupResultOk;
                end
            end,
            [PopupButtonsOkCancel] = function ()
                if (imgui.Button('Ok', { 120, 0 })) then
                    imgui.CloseCurrentPopup();
                    res = PopupResultOk;
                end
                imgui.SameLine();
                if (imgui.Button('Cancel', { 120, 0 })) then
                    imgui.CloseCurrentPopup();
                    res = PopupResultCancel;
                end
            end,
            [PopupButtonsYesNo] = function ()
                if (imgui.Button('Yes', { 120, 0 })) then
                    imgui.CloseCurrentPopup();
                    res = PopupResultYes;
                end
                imgui.SameLine();
                if (imgui.Button('No', { 120, 0 })) then
                    imgui.CloseCurrentPopup();
                    res = PopupResultNo;
                end
            end,
            [PopupButtonsYesNoCancel] = function ()
                if (imgui.Button('Yes', { 120, 0 })) then
                    imgui.CloseCurrentPopup();
                    res = PopupResultYes;
                end
                imgui.SameLine();
                if (imgui.Button('No', { 120, 0 })) then
                    imgui.CloseCurrentPopup();
                    res = PopupResultNo;
                end
                imgui.SameLine();
                if (imgui.Button('Cancel', { 120, 0 })) then
                    imgui.CloseCurrentPopup();
                    res = PopupResultCancel;
                end
            end,
        });

        -- Complete the popup..
        imgui.EndPopup();
    end

    return res;
end

return imgui;