require('common');

local buffTable = {};
    
buffTable.spellToDebuff = T{
    [230] = 135, --bio
    [23] = 134, --dia
    [24] = 134, --dia_II
    [25] = 134, --dia_III
    [58] = 4, --paralyze
    [80] = 4, --paralyze_II
    [56] = 13, --slow
    [79] = 13, --slow_II
    [357] = 13, -- slowga
    [216] = 12, --gravity
    [217] = 12, --gravity_II
    [254] = 5, --blind
    [276] = 5, --blind_II
    [361] = 5, --blindga
    [59] = 6, --silence
    [359] = 6, --silencega
    [253] = 2, --sleep
    [259] = 2, --sleep_II
    [273] = 2, --sleepga
    [274] = 2, --sleepga_II
    [258] = 11, --bind
    [362] = 11, --bindga
    [252] = 10, --stun
    [220] = 3, --poison
    [221] = 3, --poison_II
    [222] = 3, --poison_III
    [223] = 3, --poison_IV
    [224] = 3, --poison_V
    [225] = 3, --poisonga
    [226] = 3, --poisonga_II
    [227] = 3, --poisonga_III
    [228] = 3, --poisonga_IV
    [229] = 3, --poisonga_V
    [536] = 3, --poison_breath ? is this correct?
    [239] = 132, --shock
    [238] = 131, --rasp
    [237] = 130, --choke
    [236] = 129, --frost
    [608] = 129, --frost_breath ? is this correct?
    [235] = 128, --burn
    [240] = 133, --drown
    [421] = 194, --battlefield_elegy
    [422] = 194, --carnage_elegy
    [423] = 194, --massacre_elegy
    [368] = 192, --requiem_1
    [369] = 192, --requiem_2
    [370] = 192, --requiem_3
    [371] = 192, --requiem_4
    [372] = 192, --requiem_5
    [373] = 192, --requiem_6
    [463] = 193, --foe_lullaby
    [376] = 193, --horde_lullaby
    [454] = 217, --fire_threnody
    [455] = 217, --ice_threnody
    [456] = 217, --wind_threnody
    [457] = 217, --earth_threnody
    [458] = 217, --lightning_threnody
    [459] = 217, --water_threnody
    [460] = 217, --light_threnody
    [461] = 217, --dark_threnody
};


buffTable.spAbilitys = T{
    ['WAR'] = 1, -- Mighty Strikes',
    ['MNK'] = 1, -- Hundred Fists',
    ['WHM'] = 1, -- Benediction',
    ['BLM'] = 1, -- Manafont',
    ['RDM'] = 1, -- Chainspell',
    ['THF'] = 1, -- Perfect Dodge',
    ['PLD'] = 1, -- Invincible',
    ['DRK'] = 1, -- Blood Weapon',
    ['BST'] = 1, -- Familiar',
    ['BRD'] = 1, -- Soul Voice',
    ['RNG'] = 1, -- Eagle Eye Shot',
    ['SAM'] = 1, -- Meikyo Shisui',
    ['NIN'] = 1, -- Mijin Gakure',
    ['DRG'] = 1, -- Spirit Surge',
    ['SMN'] = 1, -- Astral Flow',
    ['BLU'] = 1, -- Azure Lore',
    ['COR'] = 1, -- Wild Card',
    ['PUP'] = 1, -- Overdrive',
    ['DNC'] = 1, -- Trance',
    ['SCH'] = 1, -- Tabula Rasa',
    ['GEO'] = 1, -- Bolster',
    ['RUN'] = 1, -- Elemental Sforzo'
}

buffTable.spellcasters = T{
    ['WHM'] = 1,
    ['BLM'] = 1,
    ['RDM'] = 1,
    ['PLD'] = 1,
    ['DRK'] = 1,
    ['SMN'] = 1,
    ['BLU'] = 1,
    ['SCH'] = 1,
    ['GEO'] = 1,
    ['RUN'] = 1,
}

buffTable.jugPets = T{
    ['HareFamiliar'] = 1,
    ['SheepFamiliar'] = 1,
    ['FlowerpotBill'] = 1,
    ['TigerFamiliar'] = 1,
    ['FlytrapFamiliar'] = 1,
    ['LizardFamiliar'] = 1,
    ['MayflyFamiliar'] = 1,
    ['EftFamiliar'] = 1,
    ['BeetleFamiliar'] = 1,
    ['AntlionFamiliar'] = 1,
    ['CrabFamiliar'] = 1,
    ['MiteFamiliar'] = 1,
    ['KeenearedSteffi'] = 1,
    ['LullabyMelodia'] = 1,
    ['FlowerpotBen'] = 1,
    ['SaberSiravarde'] = 1,
    ['FunguarFamiliar'] = 1,
    ['ShellbusterOrob'] = 1,
    ['ColdbloodComo'] = 1,
    ['CourierCarrie'] = 1,
    ['Homunculus'] = 1,
    ['VoraciousAudrey'] = 1,
    ['AmbusherAllie'] = 1,
    ['PanzerGalahad'] = 1,
    ['LifedrinkerLars'] = 1,
    ['ChopsueyChuky'] = 1,
    ['AmigoSabotender'] = 1,
    ['NurseryNazuna'] = 1,
    ['CraftyClyvonne'] = 1,
    ['PrestoJulio'] = 1,
    ['SwiftSieghard'] = 1,
    ['MailbusterCetas'] = 1,
    ['AudaciousAnna'] = 1,
    ['SlipperySilas'] = 1,
    ['TurbidToloi'] = 1,
    ['LuckyLulush'] = 1,
    ['DipperYuly'] = 1,
    ['FlowerpotMerle'] = 1,
    ['DapperMac'] = 1,
    ['DiscreetLouise'] = 1,
    ['FatsoFargann'] = 1,
    ['FaithfulFalcorr'] = 1,
    ['BugeyedBroncha'] = 1,
    ['BloodclawShasra'] = 1,
    ['GorefangHobs'] = 1,
    ['GooeyGerard'] = 1,
    ['CrudeRaphie'] = 1,
    ['DroppyDortwin'] = 1,
    ['SunburstMalfik'] = 1,
    ['WarlikePatrick'] = 1,
    ['ScissorlegXerin'] = 1,
    ['RhymingShizuna'] = 1,
    ['AttentiveIbuki'] = 1,
    ['AmiableRoche'] = 1,
    ['BrainyWaluis'] = 1,
    ['HeraldHenry'] = 1,
    ['SuspiciousAlice'] = 1,
    ['HeadbreakerKen'] = 1,
    ['RedolentCandi'] = 1,
    ['AnklebiterJedd'] = 1,
    ['CaringKiyomaro'] = 1,
    ['HurlerPercival'] = 1,
    ['BlackbeardRandy'] = 1,
    ['FleetReinhard'] = 1,
    ['AlluringHoney'] = 1,
    ['BouncingBertha'] = 1,
    ['BraveHeroGlenn'] = 1,
    ['CursedAnnabelle'] = 1,
    ['GenerousArthur'] = 1,
    ['SharpwitHermes'] = 1,
    ['SwoopingZhivago'] = 1,
    ['ThreestarLynn'] = 1
}

-- all of our status effects, 1 being debuffs, 0 being buffs
buffTable.statusEffects =
T{
    [1] = 1, -- weakness',
    [2] = 1, -- sleep',
    [3] = 1, -- poison',
    [4] = 1, -- paralysis',
    [5] = 1, -- blindess',
    [6] = 1, -- silence',
    [7] = 1, -- pertrification',
    [8] = 1, -- disease',
    [9] = 1, -- curse I',
    [10] = 1, -- stun',
    [11] = 1, -- bind',
    [12] = 1, -- weight',
    [13] = 1, -- slow',
    [14] = 1, -- charm I',
    [15] = 1, -- doom',
    [16] = 1, -- amnesia',
    [17] = 1, -- charm II',
    [18] = 1, -- gradual petrification',
    [19] = 1, -- sleep II',
    [20] = 1, -- curse II',
    [21] = 1, -- addle',
    [22] = 1, -- intimidate',
    [23] = 1, -- kaustra',
    [28] = 1, -- terror',
    [29] = 1, -- mute',
    [30] = 1, -- bane',
    [31] = 1, -- plague',
    [128] = 1, -- burn',
    [129] = 1, -- frost',
    [130] = 1, -- choke',
    [131] = 1, -- rasp',
    [132] = 1, -- shock',
    [133] = 1, -- drown',
    [134] = 1, -- dia',
    [135] = 1, -- bio',
    [136] = 1, -- str down',
    [137] = 1, -- dex down',
    [138] = 1, -- vit down',
    [139] = 1, -- agi down',
    [140] = 1, -- int down',
    [141] = 1, -- mnd down',
    [142] = 1, -- chr down',
    [143] = 1, -- level restriction',
    [144] = 1, -- max hp down',
    [145] = 1, -- max mp down',
    [146] = 1, -- accuracy down',
    [147] = 1, -- attack down',
    [148] = 1, -- evasion down',
    [149] = 1, -- defense down',
    [155] = 1, -- medicine',
    [156] = 1, -- flash',
    [168] = 1, -- inhibit tp',
    [171] = 1, -- pax',
    [172] = 1, -- intension',
    [173] = 1, -- dread spikes',
    [174] = 1, -- magic acc down',
    [175] = 1, -- magic atk down',
    [186] = 1, -- helix',
    [189] = 1, -- max tp down',
    [192] = 1, -- requiem',
    [193] = 1, -- lullaby',
    [194] = 1, -- elegy',
    [259] = 1, -- encumberance I',
    [260] = 1, -- obliviscence',
    [261] = 1, -- impairment',
    [262] = 1, -- omerta',
    [263] = 1, -- debilitation',
    [264] = 1, -- pathos',
    [291] = 1, -- enmity_down',
    [298] = 1, -- crit hit evasion down',
    [299] = 1, -- overload',
    [309] = 1, -- bust',
    [391] = 1, -- SLUGGISH_DAZE_1',
    [392] = 1, -- SLUGGISH_DAZE_1',
    [393] = 1, -- SLUGGISH_DAZE_1',
    [394] = 1, -- SLUGGISH_DAZE_1',
    [395] = 1, -- SLUGGISH_DAZE_1',
    [396] = 1, -- WEAKENED_DAZE_1',
    [397] = 1, -- WEAKENED_DAZE_1',
    [398] = 1, -- WEAKENED_DAZE_1',
    [399] = 1, -- WEAKENED_DAZE_1',
    [400] = 1, -- WEAKENED_DAZE_1',
    [448] = 1, -- BEWILDERED_DAZE_1',
    [449] = 1, -- BEWILDERED_DAZE_1',
    [450] = 1, -- BEWILDERED_DAZE_1',
    [451] = 1, -- BEWILDERED_DAZE_1',
    [452] = 1, -- BEWILDERED_DAZE_1',
    [404] = 1, -- MAGIC_EVASION_DOWN',
    [557] = 1, -- GEO_ATTACK_DOWN',
    [536] = 1, -- GAMBIT',
    [558] = 1, -- GEO_DEFENSE_DOWN',
    [559] = 1, -- GEO_MAGIC_ATK_DOWN',
    [560] = 1, -- GEO_MAGIC_DEF_DOWN',
    [561] = 1, -- GEO_ACCURACY_DOWN',
    [562] = 1, -- GEO_EVASION_DOWN',
    [563] = 1, -- GEO_MAGIC_ACC_DOWN',
    [564] = 1, -- GEO_MAGIC_EVASION_DOWN',
    [565] = 1, -- GEO_SLOW',
    [566] = 1, -- GEO_PARALYSIS',
    [567] = 1, -- GEO_WEIGHT',
    [572] = 1, -- AVOIDANCE_DOWN',
    [576] = 1, -- DOUBT',
    [597] = 1, -- INUNDATION',
    [630] = 1, -- TAINT',
    [631] = 1, -- HAUNT',
    -- Buffs
    [32] = 0, --    FLEE                    
    [33] = 0, --    HASTE                   
    [34] = 0, --    BLAZE_SPIKES            
    [35] = 0, --    ICE_SPIKES              
    [36] = 0, --    BLINK                   
    [37] = 0, --    STONESKIN               
    [38] = 0, --    SHOCK_SPIKES            
    [39] = 0, --    AQUAVEIL                
    [40] = 0, --    PROTECT                 
    [41] = 0, --    SHELL                   
    [42] = 0, --    REGEN                   
    [43] = 0, --    REFRESH                 
    [44] = 0, --    MIGHTY_STRIKES          
    [45] = 0, --    BOOST                   
    [46] = 0, --    HUNDRED_FISTS           
    [47] = 0, --    MANAFONT                
    [48] = 0, --    CHAINSPELL              
    [49] = 0, --    PERFECT_DODGE           
    [50] = 0, --    INVINCIBLE              
    [51] = 0, --    BLOOD_WEAPON            
    [52] = 0, --    SOUL_VOICE              
    [53] = 0, --    EAGLE_EYE_SHOT          
    [54] = 0, --    MEIKYO_SHISUI           
    [55] = 0, --    ASTRAL_FLOW             
    [56] = 0, --    BERSERK                 
    [57] = 0, --    DEFENDER                
    [58] = 0, --    AGGRESSOR               
    [59] = 0, --    FOCUS                   
    [60] = 0, --    DODGE                   
    [61] = 0, --    COUNTERSTANCE           
    [62] = 0, --    SENTINEL                
    [63] = 0, --    SOULEATER               
    [64] = 0, --    LAST_RESORT             
    [65] = 0, --    SNEAK_ATTACK            
    [66] = 0, --    COPY_IMAGE              
    [67] = 0, --    THIRD_EYE               
    [68] = 0, --    WARCRY                  
    [69] = 0, --    INVISIBLE               
    [70] = 0, --    DEODORIZE               
    [71] = 0, --    SNEAK                   
    [72] = 0, --    SHARPSHOT               
    [73] = 0, --    BARRAGE                 
    [74] = 0, --    HOLY_CIRCLE             
    [75] = 0, --    ARCANE_CIRCLE           
    [76] = 0, --    HIDE                    
    [77] = 0, --    CAMOUFLAGE              
    [78] = 0, --    DIVINE_SEAL             
    [79] = 0, --    ELEMENTAL_SEAL          
    [80] = 0, --    STR_BOOST               
    [81] = 0, --    DEX_BOOST               
    [82] = 0, --    VIT_BOOST               
    [83] = 0, --    AGI_BOOST               
    [84] = 0, --    INT_BOOST               
    [85] = 0, --    MND_BOOST               
    [86] = 0, --    CHR_BOOST               
    [87] = 0, --    TRICK_ATTACK            
    [88] = 0, --    MAX_HP_BOOST            
    [89] = 0, --    MAX_MP_BOOST            
    [90] = 0, --    ACCURACY_BOOST          
    [91] = 0, --    ATTACK_BOOST            
    [92] = 0, --    EVASION_BOOST           
    [93] = 0, --    DEFENSE_BOOST           
    [94] = 0, --    ENFIRE                  
    [95] = 0, --    ENBLIZZARD              
    [96] = 0, --    ENAERO                  
    [97] = 0, --    ENSTONE                 
    [98] = 0, --    ENTHUNDER               
    [99] = 0, --    ENWATER                 
    [100] = 0, --    BARFIRE                 
    [101] = 0, --    BARBLIZZARD             
    [102] = 0, --    BARAERO                 
    [103] = 0, --    BARSTONE                
    [104] = 0, --    BARTHUNDER              
    [105] = 0, --    BARWATER                
    [106] = 0, --    BARSLEEP                
    [107] = 0, --    BARPOISON               
    [108] = 0, --    BARPARALYZE             
    [109] = 0, --    BARBLIND                
    [110] = 0, --    BARSILENCE              
    [111] = 0, --    BARPETRIFY              
    [112] = 0, --    BARVIRUS                
    [113] = 0, --    RERAISE                 
    [114] = 0, --    COVER                   
    [115] = 0, --    UNLIMITED_SHOT          
    [116] = 0, --    PHALANX                 
    [117] = 0, --    WARDING_CIRCLE          
    [118] = 0, --    ANCIENT_CIRCLE          
    [119] = 0, --    STR_BOOST_II            
    [120] = 0, --    DEX_BOOST_II            
    [121] = 0, --    VIT_BOOST_II            
    [122] = 0, --    AGI_BOOST_II            
    [123] = 0, --    INT_BOOST_II            
    [124] = 0, --    MND_BOOST_II            
    [125] = 0, --    CHR_BOOST_II            
    [126] = 0, --    SPIRIT_SURGE            
    [127] = 0, --    COSTUME                 
    [150] = 0, --    PHYSICAL_SHIELD         
    [151] = 0, --    ARROW_SHIELD            
    [152] = 0, --    MAGIC_SHIELD            
    [153] = 0, --    DAMAGE_SPIKES           
    [154] = 0, --    SHINING_RUBY            
    [157] = 0, --    SJ_RESTRICTION          
    [159] = 0, --    PENALTY                 
    [160] = 0, --    PREPARATIONS            
    [161] = 0, --    SPRINT                  
    [162] = 0, --    ENCHANTMENT             
    [163] = 0, --    AZURE_LORE              
    [164] = 0, --    CHAIN_AFFINITY          
    [165] = 0, --    BURST_AFFINITY          
    [166] = 0, --    OVERDRIVE               
    [167] = 0, --    MAGIC_DEF_DOWN          
    [169] = 0, --    POTENCY                 
    [170] = 0, --    REGAIN                  
    [176] = 0, --    QUICKENING              
    [177] = 0, --    ENCUMBRANCE_II          
    [178] = 0, --    FIRESTORM               
    [179] = 0, --    HAILSTORM               
    [180] = 0, --    WINDSTORM               
    [181] = 0, --    SANDSTORM               
    [182] = 0, --    THUNDERSTORM            
    [183] = 0, --    RAINSTORM               
    [184] = 0, --    AURORASTORM             
    [185] = 0, --    VOIDSTORM               
    [187] = 0, --    SUBLIMATION_ACTIVATED   
    [188] = 0, --    SUBLIMATION_COMPLETE    
    [190] = 0, --    MAGIC_ATK_BOOST         
    [191] = 0, --    MAGIC_DEF_BOOST         
    [195] = 0, --    PAEON                   
    [196] = 0, --    BALLAD                  
    [197] = 0, --    MINNE                   
    [198] = 0, --    MINUET                  
    [199] = 0, --    MADRIGAL                
    [200] = 0, --    PRELUDE                 
    [201] = 0, --    MAMBO                   
    [202] = 0, --    AUBADE                  
    [203] = 0, --    PASTORAL                
    [204] = 0, --    HUM                     
    [205] = 0, --    FANTASIA                
    [206] = 0, --    OPERETTA                
    [207] = 0, --    CAPRICCIO               
    [208] = 0, --    SERENADE                
    [209] = 0, --    ROUND                   
    [210] = 0, --    GAVOTTE                 
    [211] = 0, --    FUGUE                   
    [212] = 0, --    RHAPSODY                
    [213] = 0, --    ARIA                    
    [214] = 0, --    MARCH                   
    [215] = 0, --    ETUDE                   
    [216] = 0, --    CAROL                   
    [217] = 0, --    THRENODY                
    [218] = 0, --    HYMNUS                  
    [219] = 0, --    MAZURKA                 
    [220] = 0, --    SIRVENTE                
    [221] = 0, --    DIRGE                   
    [222] = 0, --    SCHERZO                 
    [227] = 0, --    STORE_TP                
    [228] = 0, --    EMBRAVA                 
    [229] = 0, --    MANAWELL                
    [230] = 0, --    SPONTANEITY             
    [231] = 0, --    MARCATO                 
    [233] = 0, --    AUTO_REGEN              
    [234] = 0, --    AUTO_REFRESH            
    [235] = 0, --    FISHING_IMAGERY         
    [236] = 0, --    WOODWORKING_IMAGERY     
    [237] = 0, --    SMITHING_IMAGERY        
    [238] = 0, --    GOLDSMITHING_IMAGERY    
    [239] = 0, --    CLOTHCRAFT_IMAGERY      
    [240] = 0, --    LEATHERCRAFT_IMAGERY    
    [241] = 0, --    BONECRAFT_IMAGERY       
    [242] = 0, --    ALCHEMY_IMAGERY         
    [243] = 0, --    COOKING_IMAGERY         
    [244] = 0, --    IMAGERY_1               
    [245] = 0, --    IMAGERY_2               
    [246] = 0, --    IMAGERY_3               
    [247] = 0, --    IMAGERY_4               
    [248] = 0, --    IMAGERY_5               
    [249] = 0, --    DEDICATION              
    [250] = 0, --    EF_BADGE                
    [251] = 0, --    FOOD                    
    [252] = 0, --    MOUNTED                 
    [253] = 0, --    SIGNET                  
    [254] = 0, --    BATTLEFIELD             
    [256] = 0, --    SANCTION                
    [257] = 0, --    BESIEGED                
    [258] = 0, --    ILLUSION                
    [265] = 0, --    FLURRY                  
    [266] = 0, --    CONCENTRATION           
    [267] = 0, --    ALLIED_TAGS             
    [268] = 0, --    SIGIL                   
    [269] = 0, --    LEVEL_SYNC              
    [270] = 0, --    AFTERMATH_LV1           
    [271] = 0, --    AFTERMATH_LV2           
    [272] = 0, --    AFTERMATH_LV3           
    [273] = 0, --    AFTERMATH               
    [274] = 0, --    ENLIGHT                 
    [275] = 0, --    AUSPICE                 
    [276] = 0, --    CONFRONTATION           
    [277] = 0, --    ENFIRE_II               
    [278] = 0, --    ENBLIZZARD_II           
    [279] = 0, --    ENAERO_II               
    [280] = 0, --    ENSTONE_II              
    [281] = 0, --    ENTHUNDER_II            
    [282] = 0, --    ENWATER_II              
    [283] = 0, --    PERFECT_DEFENSE         
    [284] = 0, --    EGG                     
    [285] = 0, --    VISITANT                
    [286] = 0, --    BARAMNESIA              
    [287] = 0, --    ATMA                    
    [288] = 0, --    ENDARK                  
    [289] = 0, --    ENMITY_BOOST            
    [290] = 0, --    SUBTLE_BLOW_PLUS        
    [292] = 0, --    PENNANT                 
    [293] = 0, --    NEGATE_PETRIFY          
    [294] = 0, --    NEGATE_TERROR           
    [295] = 0, --    NEGATE_AMNESIA          
    [296] = 0, --    NEGATE_DOOM             
    [297] = 0, --    NEGATE_POISON           
    [300] = 0, --    FIRE_MANEUVER           
    [301] = 0, --    ICE_MANEUVER            
    [302] = 0, --    WIND_MANEUVER           
    [303] = 0, --    EARTH_MANEUVER          
    [304] = 0, --    THUNDER_MANEUVER        
    [305] = 0, --    WATER_MANEUVER          
    [306] = 0, --    LIGHT_MANEUVER          
    [307] = 0, --    DARK_MANEUVER           
    [308] = 0, --    DOUBLE_UP_CHANCE        
    [310] = 0, --    FIGHTERS_ROLL           
    [311] = 0, --    MONKS_ROLL              
    [312] = 0, --    HEALERS_ROLL            
    [313] = 0, --    WIZARDS_ROLL            
    [314] = 0, --    WARLOCKS_ROLL           
    [315] = 0, --    ROGUES_ROLL             
    [316] = 0, --    GALLANTS_ROLL           
    [317] = 0, --    CHAOS_ROLL              
    [318] = 0, --    BEAST_ROLL              
    [319] = 0, --    CHORAL_ROLL             
    [320] = 0, --    HUNTERS_ROLL            
    [321] = 0, --    SAMURAI_ROLL            
    [322] = 0, --    NINJA_ROLL              
    [323] = 0, --    DRACHEN_ROLL            
    [324] = 0, --    EVOKERS_ROLL            
    [325] = 0, --    MAGUSS_ROLL             
    [326] = 0, --    CORSAIRS_ROLL           
    [327] = 0, --    PUPPET_ROLL             
    [328] = 0, --    DANCERS_ROLL            
    [329] = 0, --    SCHOLARS_ROLL           
    [330] = 0, --    BOLTERS_ROLL            
    [331] = 0, --    CASTERS_ROLL            
    [332] = 0, --    COURSERS_ROLL           
    [333] = 0, --    BLITZERS_ROLL           
    [334] = 0, --    TACTICIANS_ROLL         
    [335] = 0, --    ALLIES_ROLL             
    [336] = 0, --    MISERS_ROLL             
    [337] = 0, --    COMPANIONS_ROLL         
    [338] = 0, --    AVENGERS_ROLL           
    [339] = 0, --    NATURALISTS_ROLL        
    [340] = 0, --    WARRIORS_CHARGE         
    [341] = 0, --    FORMLESS_STRIKES        
    [342] = 0, --    ASSASSINS_CHARGE        
    [343] = 0, --    FEINT                   
    [344] = 0, --    FEALTY                  
    [345] = 0, --    DARK_SEAL               
    [346] = 0, --    DIABOLIC_EYE            
    [347] = 0, --    NIGHTINGALE             
    [348] = 0, --    TROUBADOUR              
    [349] = 0, --    KILLER_INSTINCT         
    [350] = 0, --    STEALTH_SHOT            
    [351] = 0, --    FLASHY_SHOT             
    [352] = 0, --    SANGE                   
    [353] = 0, --    HASSO                   
    [354] = 0, --    SEIGAN                  
    [355] = 0, --    CONVERGENCE             
    [356] = 0, --    DIFFUSION               
    [357] = 0, --    SNAKE_EYE               
    [358] = 0, --    LIGHT_ARTS              
    [359] = 0, --    DARK_ARTS               
    [360] = 0, --    PENURY                  
    [361] = 0, --    PARSIMONY               
    [362] = 0, --    CELERITY                
    [363] = 0, --    ALACRITY                
    [364] = 0, --    RAPTURE                 
    [365] = 0, --    EBULLIENCE              
    [366] = 0, --    ACCESSION               
    [367] = 0, --    MANIFESTATION           
    [368] = 0, --    DRAIN_SAMBA             
    [369] = 0, --    ASPIR_SAMBA             
    [370] = 0, --    HASTE_SAMBA             
    [371] = 0, --    VELOCITY_SHOT           
    [375] = 0, --    BUILDING_FLOURISH       
    [376] = 0, --    TRANCE                  
    [377] = 0, --    TABULA_RASA             
    [378] = 0, --    DRAIN_DAZE              
    [379] = 0, --    ASPIR_DAZE              
    [380] = 0, --    HASTE_DAZE              
    [381] = 0, --    FINISHING_MOVE_1        
    [382] = 0, --    FINISHING_MOVE_2        
    [383] = 0, --    FINISHING_MOVE_3        
    [384] = 0, --    FINISHING_MOVE_4        
    [385] = 0, --    FINISHING_MOVE_5        
    [386] = 0, --    LETHARGIC_DAZE_1        
    [387] = 0, --    LETHARGIC_DAZE_2        
    [388] = 0, --    LETHARGIC_DAZE_3        
    [389] = 0, --    LETHARGIC_DAZE_4        
    [390] = 0, --    LETHARGIC_DAZE_5        
    [401] = 0, --    ADDENDUM_WHITE          
    [402] = 0, --    ADDENDUM_BLACK          
    [403] = 0, --    REPRISAL                
    [405] = 0, --    RETALIATION             
    [406] = 0, --    FOOTWORK                
    [407] = 0, --    KLIMAFORM               
    [408] = 0, --    SEKKANOKI               
    [409] = 0, --    PIANISSIMO              
    [410] = 0, --    SABER_DANCE             
    [411] = 0, --    FAN_DANCE               
    [412] = 0, --    ALTRUISM                
    [413] = 0, --    FOCALIZATION            
    [414] = 0, --    TRANQUILITY             
    [415] = 0, --    EQUANIMITY              
    [416] = 0, --    ENLIGHTENMENT           
    [417] = 0, --    AFFLATUS_SOLACE         
    [418] = 0, --    AFFLATUS_MISERY         
    [419] = 0, --    COMPOSURE               
    [420] = 0, --    YONIN                   
    [421] = 0, --    INNIN                   
    [422] = 0, --    CARBUNCLES_FAVOR        
    [423] = 0, --    IFRITS_FAVOR            
    [424] = 0, --    SHIVAS_FAVOR            
    [425] = 0, --    GARUDAS_FAVOR           
    [426] = 0, --    TITANS_FAVOR            
    [427] = 0, --    RAMUHS_FAVOR            
    [428] = 0, --    LEVIATHANS_FAVOR        
    [429] = 0, --    FENRIRS_FAVOR           
    [430] = 0, --    DIABOLOSS_FAVOR         
    [431] = 0, --    AVATARS_FAVOR           
    [432] = 0, --    MULTI_STRIKES           
    [433] = 0, --    DOUBLE_SHOT             
    [434] = 0, --    TRANSCENDENCY           
    [435] = 0, --    RESTRAINT               
    [436] = 0, --    PERFECT_COUNTER         
    [437] = 0, --    MANA_WALL               
    [438] = 0, --    DIVINE_EMBLEM           
    [439] = 0, --    NETHER_VOID             
    [440] = 0, --    SENGIKORI               
    [441] = 0, --    FUTAE                   
    [442] = 0, --    PRESTO                  
    [443] = 0, --    CLIMACTIC_FLOURISH      
    [444] = 0, --    COPY_IMAGE_2            
    [445] = 0, --    COPY_IMAGE_3            
    [446] = 0, --    COPY_IMAGE_4            
    [447] = 0, --    MULTI_SHOTS             
    [453] = 0, --    DIVINE_CARESS_I         
    [454] = 0, --    SABOTEUR                
    [455] = 0, --    TENUTO                  
    [456] = 0, --    SPUR                    
    [457] = 0, --    EFFLUX                  
    [458] = 0, --    EARTHEN_ARMOR           
    [459] = 0, --    DIVINE_CARESS_II        
    [460] = 0, --    BLOOD_RAGE              
    [461] = 0, --    IMPETUS                 
    [462] = 0, --    CONSPIRATOR             
    [463] = 0, --    SEPULCHER               
    [464] = 0, --    ARCANE_CREST            
    [465] = 0, --    HAMANOHA                
    [466] = 0, --    DRAGON_BREAKER          
    [467] = 0, --    TRIPLE_SHOT             
    [468] = 0, --    STRIKING_FLOURISH       
    [469] = 0, --    PERPETUANCE             
    [470] = 0, --    IMMANENCE               
    [471] = 0, --    MIGAWARI                
    [472] = 0, --    TERNARY_FLOURISH        
    [473] = 0, --    MUDDLE                  
    [474] = 0, --    PROWESS                 
    [475] = 0, --    VOIDWATCHER             
    [476] = 0, --    ENSPHERE                
    [477] = 0, --    SACROSANCTITY           
    [478] = 0, --    PALISADE                
    [479] = 0, --    SCARLET_DELIRIUM        
    [480] = 0, --    SCARLET_DELIRIUM_1      
    [481] = 0, --    ABDHALJS_SEAL           
    [482] = 0, --    DECOY_SHOT              
    [483] = 0, --    HAGAKURE                
    [484] = 0, --    ISSEKIGAN               
    [485] = 0, --    UNBRIDLED_LEARNING      
    [486] = 0, --    COUNTER_BOOST           
    [487] = 0, --    ENDRAIN                 
    [488] = 0, --    ENASPIR                 
    [489] = 0, --    AFTERGLOW               
    [490] = 0, --    BRAZEN_RUSH             
    [491] = 0, --    INNER_STRENGTH          
    [492] = 0, --    ASYLUM                  
    [493] = 0, --    SUBTLE_SORCERY          
    [494] = 0, --    STYMIE                  
    [496] = 0, --    INTERVENE               
    [497] = 0, --    SOUL_ENSLAVEMENT        
    [498] = 0, --    UNLEASH                 
    [499] = 0, --    CLARION_CALL            
    [500] = 0, --    OVERKILL                
    [501] = 0, --    YAEGASUMI               
    [502] = 0, --    MIKAGE                  
    [503] = 0, --    FLY_HIGH                
    [504] = 0, --    ASTRAL_CONDUIT          
    [505] = 0, --    UNBRIDLED_WISDOM        
    [507] = 0, --    GRAND_PAS               
    [508] = 0, --    WIDENED_COMPASS         
    [509] = 0, --    ODYLLIC_SUBTERFUGE      
    [510] = 0, --    ERGON_MIGHT             
    [511] = 0, --    REIVE_MARK              
    [512] = 0, --    IONIS                   
    [513] = 0, --    BOLSTER                 
    [515] = 0, --    LASTING_EMANATION       
    [516] = 0, --    ECLIPTIC_ATTRITION      
    [517] = 0, --    COLLIMATED_FERVOR       
    [518] = 0, --    DEMATERIALIZE           
    [519] = 0, --    THEURGIC_FOCUS          
    [522] = 0, --    ELEMENTAL_SFORZO        
    [523] = 0, --    IGNIS                   
    [524] = 0, --    GELUS                   
    [525] = 0, --    FLABRA                  
    [526] = 0, --    TELLUS                  
    [527] = 0, --    SULPOR                  
    [528] = 0, --    UNDA                    
    [529] = 0, --    LUX                     
    [530] = 0, --    TENEBRAE                
    [531] = 0, --    VALLATION               
    [532] = 0, --    SWORDPLAY               
    [533] = 0, --    PFLUG                   
    [534] = 0, --    EMBOLDEN                
    [535] = 0, --    VALIANCE                
    [537] = 0, --    LIEMENT                 
    [538] = 0, --    ONE_FOR_ALL             
    [539] = 0, --    GEO_REGEN               
    [540] = 0, --    GEO_POISON              
    [541] = 0, --    GEO_REFRESH             
    [542] = 0, --    GEO_STR_BOOST           
    [543] = 0, --    GEO_DEX_BOOST           
    [544] = 0, --    GEO_VIT_BOOST           
    [545] = 0, --    GEO_AGI_BOOST           
    [546] = 0, --    GEO_INT_BOOST           
    [547] = 0, --    GEO_MND_BOOST           
    [548] = 0, --    GEO_CHR_BOOST           
    [549] = 0, --    GEO_ATTACK_BOOST        
    [550] = 0, --    GEO_DEFENSE_BOOST       
    [551] = 0, --    GEO_MAGIC_ATK_BOOST     
    [552] = 0, --    GEO_MAGIC_DEF_BOOST     
    [553] = 0, --    GEO_ACCURACY_BOOST      
    [554] = 0, --    GEO_EVASION_BOOST       
    [555] = 0, --    GEO_MAGIC_ACC_BOOST     
    [556] = 0, --    GEO_MAGIC_EVASION_BOOST 
    [568] = 0, --    FOIL                    
    [569] = 0, --    BLAZE_OF_GLORY          
    [570] = 0, --    BATTUTA                 
    [571] = 0, --    RAYKE                   
    [573] = 0, --    DELUGE_SPIKES           
    [574] = 0, --    FAST_CAST               
    [575] = 0, --    GESTATION               
    [577] = 0, --    CAIT_SITHS_FAVOR        
    [578] = 0, --    FISHY_INTUITION         
    [579] = 0, --    COMMITMENT              
    [580] = 0, --    GEO_HASTE               
    [581] = 0, --    FLURRY_II               
    [582] = 0, --    CONTRADANCE             
    [583] = 0, --    APOGEE                  
    [584] = 0, --    ENTRUST                 
    [585] = 0, --    COSTUME_II              
    [586] = 0, --    CURING_CONDUIT          
    [587] = 0, --    TP_BONUS                
    [588] = 0, --    FINISHING_MOVE_6        
    [589] = 0, --    FIRESTORM_II            
    [590] = 0, --    HAILSTORM_II            
    [591] = 0, --    WINDSTORM_II            
    [592] = 0, --    SANDSTORM_II            
    [593] = 0, --    THUNDERSTORM_II         
    [594] = 0, --    RAINSTORM_II            
    [595] = 0, --    AURORASTORM_II          
    [596] = 0, --    VOIDSTORM_II            
    [598] = 0, --    CASCADE                 
    [599] = 0, --    CONSUME_MANA            
    [600] = 0, --    RUNEISTS_ROLL           
    [601] = 0, --    CROOKED_CARDS           
    [602] = 0, --    VORSEAL                 
    [603] = 0, --    ELVORSEAL               
    [604] = 0, --    MIGHTY_GUARD            
    [605] = 0, --    GALE_SPIKES             
    [606] = 0, --    CLOD_SPIKES             
    [607] = 0, --    GLINT_SPIKES            
    [608] = 0, --    NEGATE_VIRUS            
    [609] = 0, --    NEGATE_CURSE            
    [610] = 0, --    NEGATE_CHARM            
    [611] = 0, --    MAGIC_EVASION_BOOST     
    [612] = 0, --    COLURE_ACTIVE           
    [613] = 0, --    MUMORS_RADIANCE         
    [614] = 0, --    ULLEGORES_GLOOM         
    [615] = 0, --    BOOST_II                
    [616] = 0, --    ARTISANAL_KNOWLEDGE     
    [617] = 0, --    SACRIFICE               
    [618] = 0, --    EMPOROXS_GIFT           
    [619] = 0, --    SPIRIT_BOND             
    [620] = 0, --    AWAKEN                  
    [621] = 0, --    MAJESTY                 
    [622] = 0, --    GUARDING_RATE_BOOST     
    [623] = 0, --    RAMPART                 
    [624] = 0, --    WINDS_BLESSING          
    [625] = 0, --    SIRENS_FAVOR            
    [626] = 0, --    NEGATE_SLEEP            
    [627] = 0, --    MOBILIZATION            
    [628] = 0, --    HOVER_SHOT              
    [629] = 0, --    MOOGLE_AMPLIFIER        
    [768] = 0, --    ABYSSEA_STR             
    [769] = 0, --    ABYSSEA_DEX             
    [770] = 0, --    ABYSSEA_VIT             
    [771] = 0, --    ABYSSEA_AGI             
    [772] = 0, --    ABYSSEA_INT             
    [773] = 0, --    ABYSSEA_MND             
    [774] = 0, --    ABYSSEA_CHR             
    [775] = 0, --    ABYSSEA_HP              
    [776] = 0, --    ABYSSEA_MP              
}

buffTable.GetBuffIdBySpellId = function(spellId)
    -- check our debuffs for this spell name
    return buffTable.spellToDebuff[spellId];
end

buffTable.IsBuff = function(buffId)
    return buffTable.statusEffects[buffId] == 0;
end

buffTable.IsJugPet = function(petName)
    return buffTable.jugPets[petName] ~= nil;
end

buffTable.IsSpellcaster = function(jobAbv)
    return buffTable.spellcasters[jobAbv] ~= nil;
end

buffTable.GetSpAbilityName = function(jobAbv)
    return buffTable.spAbilitys[jobAbv];
end


return buffTable;