require('common')

local defines = require('defines')
local cc = defines.chat_color_codes

local tests = T{}

tests.short = {
    'Test',
    'Can I look after an item?',
    'ACeaN|H',
}

tests.item = {
    'Moogle',
    [[Please get me an ]] .. cc.item .. [[Orange Juice]] .. cc.standard ..
    [[ and some ]] .. cc.item .. [[Apple Pie]] .. cc.standard,
    [[r]] .. cc.item .. [[āyxuiz]] .. cc.standard ..
    [[A]] .. cc.item .. [[ibgxC]] .. cc.standard ..
    [[]] .. cc.item .. [[f[c]] .. cc.standard .. [[pӂĂقN|I]],
}

tests.clip_issue = {
    'Makki-Chebukki',
    [[...
This line used to get clipped.]],
    [[ccB
vbV̂AvȂ`]],
}

tests.unknown = {
    '???',
    'Unknown speaker...',
    [[svcȐlccB]],
}

tests.homepoint = {
    '',
    'A home point can be set as a spot for you to return to Vana\'diel when you have been knocked out. You can also use a home point to teleport to other home points.',
    [[ł̓z[|Cg𗘗pāA
퓬s\̋Aėʒu̐ݒ
̃z[|Cgւ̃[vł܂B]],
}

tests.colors = {
    'Test',
    [[P]] .. cc.item .. [[Item]] .. cc.standard .. ', ' ..
    [[Q]] .. cc.key_item .. [[Key item]] .. cc.standard .. ', ' ..
    [[R]] .. cc.blue .. [[Blue]] .. cc.standard .. ', ' ..
    [[S]] .. cc.magenta .. [[Equipment?]] .. cc.standard .. ', ' ..
    [[T]] .. cc.cyan .. [[Cyan]] .. cc.standard .. ', ' ..
    [[U]] .. cc.yellow .. [[Yellow]] .. cc.standard .. ', ' ..
    [[V]] .. cc.orange .. [[Orange]] .. cc.standard,

    [[P]] .. cc.item .. [[ACe]] .. cc.standard .. ', ' ..
    [[Q]] .. cc.key_item .. [[厖Ȃ]] .. cc.standard .. ', ' ..
    [[R]] .. cc.blue .. [[]] .. cc.standard .. ', ' ..
    [[S]] .. cc.magenta .. [[H]] .. cc.standard .. ', ' ..
    [[T]] .. cc.cyan .. [[VAF]] .. cc.standard .. ', ' ..
    [[U]] .. cc.yellow .. [[F]] .. cc.standard .. ', ' ..
    [[V]] .. cc.orange .. [[IWF]] .. cc.standard
}

tests.bahamut = {
    'Bahamut',
    "Selh'teus proved that to us ten thousand years ago. Destruction is your destiny. You cannot escape what has already been decided.",
    [[_̗͂ĂA
܂l~Ƃ͂łB
܂͊ɎłB
ɂċʂĂɂȂB]],
}

tests.punctuation_wrap = {
    'Test',
    "--testing...foo--testing...foo--testing...foo--testing...foo--testing...foo--testing...foo--" ..
    "testing...foo--testing...foo--testing...foo--testing...foo--testing...foo--testing...foo--" ..
    "foo-----testing... foo-- testing -- foo --end--",
    "--testing...foo--testing...foo--testing...foo--testing...foo--testing...foo--testing...foo--" ..
    "testing...foo--testing...foo--testing...foo--testing...foo--testing...foo--testing...foo--" ..
    "foo-----testing... foo-- testing -- foo --end--",
}

return tests