# ZXHN H298N

## config.bin

```
00000000: 9999 9999 4444 4444 5555 5555 aaaa aaaa  ....DDDDUUUU....
00000010: 0000 0000 0000 0000 0000 0004 0000 0000  ................
00000020: 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000030: 0000 0000 0000 0000 0000 0000 0000 0040  ...............@
00000040: 0002 0000 0000 0080 0000 485e 0000 0000  ..........H^....
00000050: 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000060: 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000070: 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000080: 0403 0201 0000 0000 0000 000a 5a58 484e  ............ZXHN
00000090: 2048 3239 384e 0102 0304 0000 0002 0000   H298N..........
000000a0: 0000 0000 4848 0001 0000 0000 0000 0000  ....HH..........
000000b0: 0000 0000 0000 0000 0000 0000 0000 0000  ................
000000c0: 0000 0000 0000 0000 0000 0000 0000 0000  ................
000000d0: 0000 0000 4800 0000 4800 0000 0000 a981  ....H...H.......
000000e0: bc45 7553 5763 1273 024f cb57 9742 2f61  .EuSWc.s.O.W.B/a
000000f0: 3030 d022 37d3 9e49 8577 c8c5 90d4 7181  00."7..I.w....q.
00000100: 6bc7 f765 caee 53c9 a526 4596 89cb 73b9  k..e..S..&E...s.
00000110: 7741 c3a6 30f9 76ae e08b b1ce 377b 2876  wA..0.v.....7{(v
00000120: 17e9 3224 b1d0 7168 bb5f 24ba dd25 9973  ..2$..qh._$..%.s
00000130: 275a 2f1b d506 b471 ec05 b7f9 879a 2cc5  'Z/....q......,.
...etc
```

Comprising of:
 - [Header 1](#header-1) - 128 byte header
 - [Signature](#signature) - Variable length 'signature' (i.e. name of device)
 - [Payload Header](#encryption-header) - 36 byte encryption information
 - [Payload](#payload) - Variable length payload, zlib compressed and encrypted via AES

## Header 1

```
00000000: 9999 9999 4444 4444 5555 5555 aaaa aaaa  ....DDDDUUUU....
00000010: 0000 0000 0000 0000 0000 0004 0000 0000  ................
00000020: 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000030: 0000 0000 0000 0000 0000 0000 0000 0040  ...............@
00000040: 0002 0000 0000 0080 0000 485e 0000 0000  ..........H^....
00000050: 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000060: 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000070: 0000 0000 0000 0000 0000 0000 0000 0000  ................
```

### Header 1 breakdown

```
99999999 44444444 55555555 aaaaaaaa                // 16 byte magic
00000000 00000000                                  // padding
00000004                                           // version?                  / 4
00000000 00000000 00000000 00000000                // padding...
00000000 00000000 00000000 00000000
00000040                                           // 4 byte offset 3           / 80
00020000                                           // 24 byte header 3          / 131072
00000080                                           // header length?            / 128
0000485e                                           // signed config size        / 18526
00000000 00000000 00000000 00000000                // padding...
00000000 00000000 00000000 00000000
00000000 00000000 00000000 00000000
00000000
```

## Variable length signature

```
00000080: 0403 0201 0000 0000 0000 000a 5a58 484e  ............ZXHN
00000090: 2048 3239 384e                           H298N           
```

### Signature breakdown
```
04030201                                           // 4 byte magic
00000000                                           // padding
0000000a                                           // signature length          / 10
5a58484e20483239384e                               // signature                 / ZXHN H298N
````

## Payload header

```
                         0102 0304 0000 0002 0000        ..........
000000a0: 0000 0000 4848 0001 0000 0000 0000 0000  ....HH..........
000000b0: 0000 0000 0000 0000 0000 0000 0000 0000  ................
000000c0: 0000 0000 0000 0000 0000 0000 0000 0000  ................
000000d0: 0000                                     ..              
```

### Payload header breakdown

```
01020304                                           // payload magic
00000002                                           // payload type              / 2, AES
00000000                                           // padding
00004848                                           // cumulative compressed     / 18504
00010000                                           // chunk size                / 65536
00000000 00000000 00000000 00000000                // padding...
00000000 00000000 00000000 00000000
00000000 00000000
```


## Payload

```
000000d0:      0000 4800 0000 4800 0000 0000 a981    ..H...H.......
000000e0: bc45 7553 5763 1273 024f cb57 9742 2f61  .EuSWc.s.O.W.B/a
000000f0: 3030 d022 37d3 9e49 8577 c8c5 90d4 7181  00."7..I.w....q.
00000100: 6bc7 f765 caee 53c9 a526 4596 89cb 73b9  k..e..S..&E...s.
... etc
```

### Payload breakdown
```
00004800                                           // unencrypted filesize      / 18432
00004800                                           // encrypted filesize        / 18432
00000000                                           // padding
```

## Decrypted payload

```
00000000: 0102 0304 0000 0000 0004 43b3 0000 3f42  ..........C...?B
00000010: 0001 0000 8ec6 8838 c599 be0d 0000 0000  .......8........
00000020: 0000 0000 0000 0000 0000 0000 0000 0000  ................
00000030: 0000 0000 0000 0000 0000 0000 0001 0000  ................
00000040: 0000 1b36 0000 1b7e 78da ed3d 6b73 a33a  ...6...~x..=ks.:
00000050: b2df efaf 989a f36d ef1e 0f2f 3b4e 6af7  .......m.../;Nj.
00000060: 5639 604f 5c6b 3bc4 9078 f67c 9922 58b6  V9`O\k;..x.|."X.
00000070: a910 6005 cee3 d4fe f82b e117 0849 086c  ..`......+...I.l
00000080: e764 1267 2693 8cbb 11fd 56ab 919a 7f18  .d.g&.....V.....
```

### Decrypted payload breakdown

```
01020304                                           // magic
00000000                                           // padding
000443b3                                           // total decompressed length / 279475     
00003f42                                           // unknown                   / 16194
00010000                                           // decompressed chunk size   / 65536
8ec68838                                           // compressed crc            / 2395375672
c599be0d                                           // header crc                / 3315187213
00000000 00000000 00000000 00000000                // padding
00000000 00000000 00000000 00000000
00010000                                           // decompressed length       / 65536
00001b36                                           // compressed length         / 6966
00001b7e                                           // cumulative compressed     / 7038
78da                                               // zlib start                / ZLIB, BEST
```
