---
icon: rocket
label: Installation
order: 100
---
# How to install skins after the new steam update

## Pre-requisites

!!! Download the [!badge target="blank" variant="info" text="latest SFP release"](https://github.com/PhantomGamers/SFP/releases)
[!badge target="blank" variant="info" text="Windows"](https://github.com/PhantomGamers/SFP/releases/latest/download/SFP_UI-win10-x64-SelfContained.zip) [!badge target="blank" variant="info" text="Linux"](https://github.com/PhantomGamers/SFP/releases/latest/download/SFP_UI-linux-x64-SelfContained.tar.gz) [!badge target="blank" variant="info" text="Mac"](https://github.com/PhantomGamers/SFP/releases/latest/download/SFP_UI-osx-x64-SelfContained.tar.gz) [!badge text="Recommended"]
!!!
!!! Or download Millennium!, download it for [!badge target="blank" variant="info" text="Windows"](https://github.com/ShadowMonster99/millennium-steam-patcher/releases/latest)
Millennium and SFP share many similarities and are fully forward compatible! The main difference is that Millennium doesn't run in a standalone process, but is limited to Windows only. [!badge target="blank" variant="dark" text="read more at its source"](https://github.com/ShadowMonster99/millennium-steam-patcher/#readme)
!!!
!!!dark In case you want to use the CSSLoader, download it for [!badge target="blank" variant="dark" text="Windows"](https://docs.deckthemes.com/CSSLoader/Install/#windows) [!badge target="blank" variant="dark" text="Linux"](https://docs.deckthemes.com/CSSLoader/Install/#linux)
Note that this patcher has its own way of patching and you should read its documentation linked above
!!!

### Installing a theme

1. Download a theme
   - You can [!badge variant="info" text="download skins here"](#skins)
   - You can [!badge variant="info" text="preview skins here"](#previews)
2. Extract the zip and Copy/Cut the [!badge variant="dark" text="\<Skin Name\>"] folder (the folder might sometimes have -main -master or a version after the name)
3. Paste your skin(s)
   - [x] Find the steam folder using SFP [!badge variant="info" text="Recommended"]
     - Open SFP, click the [!badge variant="dark" text="Open Files"] button (bottom right), and then click [!badge variant="dark" text="skins"]/[!badge variant="dark" text="steamui"]
     - If the [!badge variant="dark" text="skins"] folder doesn't exist create it
   - [ ] or find the steam folder manually
     - Locate wherever steam is installed yourself (default is [!badge variant="dark" text="C:\Program Files (x86)\Steam"])
     - If the [!badge variant="dark" text="skins"] folder doesn't exist create it
4. Open SFP and open the Settings :icon-gear: at the bottom left
5. Scroll down and at Steam Skin choose your skin
6. Done.

## Skins

==- Fluent by Shiina
[!ref icon="download" target="blank" text="Download"](https://download-directory.github.io/?url=https://github.com/AikoMidori/SteamSkins/tree/main/Fluent/)
!!!success Extract and Copy the folder to [!badge variant="dark" text="Steam\steamui\skins"]
You can see the skin [!badge target="blank" variant="dark" text="source code here"](https://github.com/AikoMidori/SteamSkins)
!!!
==- Metro by Shiina
[!ref icon="download" target="blank" text="Download"](https://download-directory.github.io/?url=https://github.com/AikoMidori/SteamSkins/tree/main/Metro/)
!!!success Extract and Copy the folder to [!badge variant="dark" text="Steam\steamui\skins"]
You can see the skin [!badge target="blank" variant="dark" text="source code here"](https://github.com/AikoMidori/SteamSkins)
!!!
!!! If you want to use this skins JS
Move the contents of the [!badge variant="dark" text="Steam\steamui\skins\Metro\Metro-JS"] folder to the main skin folder (aka. [!badge variant="dark" text="Steam\steamui\skins\Metro"]) and overwrite existing files
!!!
==- Metro and steam chat by RoseTheFlower
[!ref icon="download" target="blank" text="Download"](https://github.com/RoseTheFlower/MetroSteam/archive/refs/heads/master.zip)
!!!success Extract and Copy [!badge variant="dark" text="friends.custom.css"], [!badge variant="dark" text="libraryroot.custom.css"] to [!badge variant="dark" text="Steam\steamui"] or make a new folder with them in [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!! You can see the skin [!badge target="blank" variant="dark" text="source code here"](https://github.com/RoseTheFlower/MetroSteam)
!!!
==- Space Theme by SpaceEnergy
[!ref icon="download" target="blank" text="Download"](https://github.com/SpaceEnergy/SpaceTheme-Steam/releases/latest/download/SpaceTheme.zip)
!!!success Extract and Copy the folder to [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!!warning This skin was made to be used with Millennium BUT it can also be used with SFP, download it at the [!badge variant="dark" text="top of this page"](/guides/installation.md#pre-requisites)
To install this skin with Millennium, you can follow the [!badge target="blank" variant="info" text="guide provided by the author"](https://github.com/SpaceEnergy/SpaceTheme-Steam#installation)
!!!
!!! You can see the skin [!badge target="blank" variant="dark" text="source code here"](https://github.com/SpaceEnergy/SpaceTheme-Steam)
!!!
==- 2013 inspired steam library by naii_
[!ref icon="download" target="blank" text="Download"](https://gamebanana.com/mods/download/305429)
!!!success Extract and Copy [!badge variant="dark" text="friends.custom.css"], [!badge variant="dark" text="libraryroot.custom.css"] to [!badge variant="dark" text="Steam\steamui"] or make a new folder with them in [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!! You can see the skin [!badge target="blank" variant="dark" text="page here"](https://gamebanana.com/mods/305429)
!!!
==- Zehn by yurisuika
[!ref icon="download" target="blank" text="Download"](https://github.com/yurisuika/Zehn/archive/refs/heads/master.zip)
!!!success Extract and Copy the folder to [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!! You can see the skin [!badge target="blank" variant="dark" text="source code here"](https://github.com/yurisuika/Zehn)
!!!
==- Knowledges SteamLib by Potato95
[!ref icon="download" target="blank" text="Download"](https://github.com/Potato95/Knowledges-SteamLib/archive/refs/heads/master.zip)
!!!success Extract and Copy the folder to [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!! You can see the skin [!badge target="blank" variant="dark" text="source code here"](https://github.com/Potato95/Knowledges-SteamLib)
!!!
==- Adwaita for Steam by tkashkin
!!!warning This skin was made for [!badge target="blank" variant="dark" text="Linux"](https://github.com/tkashkin/Adwaita-for-Steam#installation) but it supports [!badge target="blank" variant="dark" text="Windows"](https://docs.deckthemes.com/CSSLoader/Install/#windows) as well.
!!!
!!! You can see the skin [!badge target="blank" variant="dark" text="source code here"](https://github.com/tkashkin/Adwaita-for-Steam)
!!!
==- Win95 by ricewind012
[!ref icon="download" target="blank" text="Download"](https://github.com/ricewind012/win95-themes/archive/refs/heads/master.zip)
!!!success Extract and Copy the folder to [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!! You can see the skin [!badge target="blank" variant="dark" text="source code here"](https://github.com/ricewind012/win95-themes)
!!!
==- UNFINISHED: Fluenty by Hexality
This skin isn't finished yet, you can visit it's [!badge target="blank" variant="dark" text="source code here"](https://github.com/Hexality/Fluenty)
More information will be added when the skin is finished, currently visit the source code and find out how to install it.
==- More coming soon...
There aren't any other skins I could find. If there is a skin you would like added, you can edit this page and add it yourself, or tell me to add it by [!badge target="blank" variant="info" text="creating an issue on github"](https://github.com/xamionex/steamskins/issues/new?assignees=xamionex&labels=documentation&projects=&template=change-request.md&title=)
==-

## Addons for your already existing skins

Before continuing this, first install a regular skin like metro or fluent.\
Follow the guide above if you don't know how

==- Steam Friends Skin by LaserFlash
!!! :gear: This skin features a [!badge target="blank" variant="info" text="site with customizability"](https://chat.lasr.skin/) [!badge target="blank" variant="ghost" text="Source code"](https://github.com/LaserFlash/steam-chat-skin/) :gear:
!!!
To install the base skin:
[!file RIGHT CLICK this and select Save Link As](https://raw.githubusercontent.com/LaserFlash/steam-chat-skin/main/friends.custom.css)
!!!success Save it as [!badge variant="dark" text="friends.custom.css"] to [!badge variant="dark" text="Steam\steamui"] or to the folder of your active skin in [!badge variant="dark" text="Steam\steamui\skins"]
!!!
==- Dark Store pages by Shiina
[!file RIGHT CLICK this and select Save Link As](https://raw.githubusercontent.com/AikoMidori/steam-dark-mode/master/webkit.css)
[!file BETA: RIGHT CLICK this and select Save Link As](https://raw.githubusercontent.com/AikoMidori/steam-dark-mode/beta/build/css/webkit.css)
!!!success Save it as [!badge variant="dark" text="webkit.css"] to [!badge variant="dark" text="Steam\steamui"] or to the folder of your active skin in [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!! You can see the [!badge target="blank" variant="dark" text="source code here"](https://github.com/AikoMidori/steam-dark-mode) [!badge target="blank" variant="dark" text="or beta source code here"](https://github.com/AikoMidori/steam-dark-mode/tree/beta)
!!!
==- Beta Dark Store pages by BallOpener
[!file RIGHT CLICK this and select Save Link As](https://raw.githubusercontent.com/BallOpener/steam-dark-mode/beta2/css/webkit.css)
!!!success Save it as [!badge variant="dark" text="webkit.css"] to [!badge variant="dark" text="Steam\steamui"] or to the folder of your active skin in [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!! You can see the [!badge target="blank" variant="dark" text="source code here"](https://github.com/BallOpener/steam-dark-mode/tree/beta2)
!!!
==- SteamDB addon by BossSloth
!!!warning If you want to use this with other skins you should check out [!badge target="blank" variant="info" text="their guide"](https://github.com/tddebart/Steam-SteamDB-addon?tab=readme-ov-file#add-to-existing-skin)
!!!
!!! The author of this addon has [!badge target="blank" variant="info" text="install instructions"](https://github.com/tddebart/Steam-SteamDB-addon#installation) on their page.
!!!
[!file Download Latest](https://github.com/tddebart/Steam-SteamDB-addon/releases/latest/download/SteamDB-addon.zip)
!!! You can see the [!badge target="blank" variant="dark" text="source code here"](https://github.com/tddebart/Steam-SteamDB-addon)
!!!
==- Better Store pages in terms of usability by RedSigma (OLD)
[!file RIGHT CLICK this and select Save Link As](/assets/css/webkit.css)
!!!success Save it as [!badge variant="dark" text="webkit.css"] to [!badge variant="dark" text="Steam\steamui"] or to the folder of your active skin in [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!!primary You can [!badge target="blank" variant="dark" text="see customizable variables for this skin here"](/assets/css/store.css)
!!!
==- More coming soon...
There aren't any other addons I could find. If there is a addon you would like added, you can edit this page and add it yourself, or tell me to add it by [!badge target="blank" variant="info" text="creating an issue on github"](https://github.com/xamionex/steamskins/issues/new?assignees=xamionex&labels=documentation&projects=&template=change-request.md&title=)
==-

## Previews

If you want to look at how some of the skins would look if you installed them this is it.

### Skin Previews

==- Metro by Shiina
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/library.png&n=/assets/images/skins/shiinametro/library.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/game.png&n=/assets/images/skins/shiinametro/game.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/skins/shiinametro/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/overlay.png&n=/assets/images/skins/shiinametro/overlay.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/friends.png&n=/assets/images/skins/shiinametro/friends.png)
==- Fluent by Shiina
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/library.png&n=/assets/images/skins/shiinafluent/library.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/game.png&n=/assets/images/skins/shiinafluent/game.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/skins/shiinafluent/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/overlay.png&n=/assets/images/skins/shiinafluent/overlay.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/friends.png&n=/assets/images/skins/shiinafluent/friends.png)
==- Metro by RoseTheFlower
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/library.png&n=/assets/images/skins/rosemetro/library.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/game.png&n=/assets/images/skins/rosemetro/game.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/skins/rosemetro/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/overlay.png&n=/assets/images/skins/rosemetro/overlay.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/friends.png&n=/assets/images/skins/rosemetro/friends.png)
==- SpaceTheme by SpaceEnergy
Note: Includes custom font
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/library.png&n=/assets/images/skins/spacetheme/library.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/game.png&n=/assets/images/skins/spacetheme/game.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/skins/spacetheme/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/overlay.png&n=/assets/images/skins/spacetheme/overlay.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/friends.png&n=/assets/images/skins/spacetheme/friends.png)
==- 2013 inspired steam library by naii_
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/library.png&n=/assets/images/skins/2013/library.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/game.png&n=/assets/images/skins/2013/game.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/skins/2013/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/overlay.png&n=/assets/images/skins/2013/overlay.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/friends.png&n=/assets/images/skins/2013/friends.png)
==- Zehn by yurisuika
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/library.png&n=/assets/images/skins/zehn/library.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/game.png&n=/assets/images/skins/zehn/game.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/skins/zehn/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/overlay.png&n=/assets/images/skins/zehn/overlay.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/friends.png&n=/assets/images/skins/zehn/friends.png)
==- Knowledges-SteamLib by Potato95
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/library.png&n=/assets/images/skins/knowledges/library.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/game.png&n=/assets/images/skins/knowledges/game.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/skins/knowledges/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/overlay.png&n=/assets/images/skins/knowledges/overlay.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/friends.png&n=/assets/images/skins/knowledges/friends.png)
==- Adwaita for Steam by tkashkin
!!!success Previews for this skin can be [!badge target="blank" variant="dark" text="viewed here"](https://github.com/tkashkin/Adwaita-for-Steam#previews) (expand previews at the top).
!!!
==- Win95 by ricewind012
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/library.png&n=/assets/images/skins/win95/library.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/game.png&n=/assets/images/skins/win95/game.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/skins/win95/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/overlay.png&n=/assets/images/skins/win95/overlay.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/friends.png&n=/assets/images/skins/win95/friends.png)
==-

### Addon Previews

==- Steam Friends Skin by LaserFlash
!!!warning The developer of this addon has a better preview page, [!badge target="blank" variant="info" text="look here"](https://chat.lasr.skin/)
![LaserFlash previews](/assets/images/addons/laserflash/friends.png)
!!!
==- Dark Store pages by Shiina
[!embed text="Non-beta"](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/addons/shiina/store.png)
[!embed text="Non-beta"](/assets/image-comparison/index.html?o=/assets/images/skins/default/storepage.png&n=/assets/images/addons/shiina/storepage.png)
[!embed text="Beta"](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/addons/shiina/storebeta.png)
[!embed text="Beta"](/assets/image-comparison/index.html?o=/assets/images/skins/default/storepage.png&n=/assets/images/addons/shiina/storebetapage.png)
==- Beta Dark Store pages by BallOpener
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/addons/ballopener/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/storepage.png&n=/assets/images/addons/ballopener/storepage.png)
==- SteamDB addon by BossSloth
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/storepage.png&n=/assets/images/addons/steamdb/storepage.png)
==- Better Store pages in terms of usability by RedSigma (OLD)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/store.png&n=/assets/images/addons/redsigma/store.png)
[!embed](/assets/image-comparison/index.html?o=/assets/images/skins/default/storepage.png&n=/assets/images/addons/redsigma/storepage.png)
==- More coming soon...
There aren't any other addons I could find. If there is a addon you would like added, you can edit this page and add it yourself, or tell me to add it by [!badge target="blank" variant="info" text="creating an issue on github"](https://github.com/xamionex/steamskins/issues/new?assignees=xamionex&labels=documentation&projects=&template=change-request.md&title=)
==-

## Uninstalling

If you want to uninstall you will have to:

- Close Steam and SFP fully (from tray menu)
- Delete the [!badge variant="dark" text="%LOCALAPPDATA%\Steam\htmlcache\Cache\"] folder
- Launch steam

!!!warning If you want to permanently delete any modifications delete SFP and [!badge variant="dark" text="Steam\steamui\skins"]
!!!
!!!danger If you're still paranoid delete the whole [!badge variant="dark" text="Steam\steamui"] folder along with [!badge variant="dark" text="Steam\clientui"] and relaunch steam
!!!
