function delay(n) {
	n = n || 2000;
	return new Promise((done) => {
		setTimeout(() => {
			done();
		}, n);
	});
}

function pageTransition() {
	var tl = gsap.timeline();
	tl.to(".load-screen, .load-text", {
		duration: 1,
		width: "100%",
		left: "0%",
		ease: "Expo.easeInOut",
	});
	tl.to(".load-screen, .load-text", {
		duration: 0.5,
		width: "100%",
		left: "100%",
		ease: "Expo.easeInOut",
		delay: 0,
	});
	tl.set(".load-screen, .load-text", { left: "-100%" });
}

function contentAnimation() {
	var tl = gsap.timeline();
	tl.to(".animate", {
		duration: 0.6,
		y: 0,
		opacity: 1,
		stagger: 0.3,
	});
}

barba.hooks.leave((data) => {
	console.log(data.next.html);
});

barba.init({
	sync: true,

	transitions: [
		{
			async leave(data) {
				const done = this.async();
				const loadtext = document.querySelector(".load-text");
				var el = document.createElement("html");
				el.innerHTML = data.next.html;
				loadtext.innerHTML = el.querySelector("title").innerHTML.replace("Petar's Site - ", "");

				pageTransition();
				await delay(1000);
				done();
			},

			async enter(data) {
				contentAnimation();
			},

			async once(data) {
				contentAnimation();
			},
		},
	],
	views: [
		{
			namespace: "index",
			afterEnter() {
				nameTyper();
				getAge("2005/11/1", "petarage");
			},
		},
		{
			namespace: "birthday",
			afterEnter() {
				bdaycountdown("1/1/", "earth", "Happy New Years!", "text-6xl");
				bdaycountdown("12/28/", "niko", "Happy BDAY Niko!", "text-2xl");
				bdaycountdown("2/21/", "mae", "Happy BDAY Mae!", "text-2xl");
				getAge("2013/12/28", "nikoage");
				getAge("1997", "maeage");
				getAge("1996", "maeage2");
			},
		},
		{
			namespace: "internal",
			afterEnter() {
				pcTyper();
			},
		},
		{
			namespace: "external",
			afterEnter() {
				pcTyper();
			},
		},
		{
			namespace: "banana",
			afterEnter() {
				Multiply(document.querySelector("#banan"), 100, true);
				Multiply(document.querySelector(".banan"), 100, true);
			},
		},
		{
			namespace: "love",
			afterEnter() {
				var sadnesses = Array("hRIAt3-49UI", "OahukX9_eC0", "Q4VbAnjLRv4", "PvUaMW4qgpw", "zRMyr8pJ6Kw", "XdU2mwcUzcg", "ggRFelXY920", "bAZB-RUmPYg", "rsMyWFiKfSc", "wJWksPWDKOc")
				var sadness = sadnesses[Math.floor(Math.random() * sadnesses.length)];
				var iframe = document.querySelector("#sadvid")
				iframe.src += sadness
			},
		},
	],
});

const jsConfetti = new JSConfetti();
/* function includeHtml() {
	var z, i, elmnt, file, xhttp;
	// loop through a collection of all HTML elements:
	z = document.getElementsByTagName("*");
	for (i = 0; i < z.length; i++) {
		elmnt = z[i];
		// search for elements with a certain atrribute:
		file = elmnt.getAttribute("include-html");
		if (file) {
			// make an HTTP request using the attribute value as the file name:
			xhttp = new XMLHttpRequest();
			xhttp.onreadystatechange = function () {
				if (this.readyState == 4) {
					if (this.status == 200) {
						elmnt.innerHTML = this.responseText;
					}
					if (this.status == 404) {
						elmnt.innerHTML = "Page not found.";
					}
					// remove the attribute, and call this function once more:
					elmnt.removeAttribute("include-html");
					includeHtml();
				}
			};
			xhttp.open("GET", file, true);
			xhttp.send();
			// exit the function:
			return;
		}
	}
} */

function Multiply(node, count, deep) {
	for (var i = 0, copy; i < count - 1; i++) {
		copy = node.cloneNode(deep);
		node.parentNode.insertBefore(copy, node);
	}
}

// kofiWidgetOverlay.draw("amione", {
// 	type: "floating-chat",
// 	"floating-chat.donateButton.text": "Donate 💖",
// 	"floating-chat.donateButton.background-color": "#00b9fe",
// 	"floating-chat.donateButton.text-color": "#fff",
// });

function nameTyper() {
	new Typewriter("#myname", {
		strings: ["Hello, I'm <strong>Petar</strong>", "I'm a <strong>Serbian Programmer</strong>", "I hope you like my site."],
		autoStart: true,
		loop: true,
		deleteSpeed: 70,
		delay: 100,
		pauseFor: 2000,
	});
}
function pcTyper() {
	new Typewriter("#specs", {
		strings: ["Stormbringer", "Stormbreaker's Twin", "Petar's PC"],
		autoStart: true,
		loop: true,
		deleteSpeed: 50,
		delay: 70,
		pauseFor: 2500,
	});
}
function getAge(dateString, ageid) {
	var today = new Date();
	var birthDate = new Date(dateString);
	var age = today.getFullYear() - birthDate.getFullYear();
	var m = today.getMonth() - birthDate.getMonth();
	if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
		age--;
	}
	// return age;
	document.getElementById(ageid).innerText = age + " years old";
}
function bdaycountdown(dayMonth, prefix, surprise, textsize) {
	const second = 1000,
		minute = second * 60,
		hour = minute * 60,
		day = hour * 24;
	let today = new Date(),
		dd = String(today.getDate()).padStart(2, "0"),
		mm = String(today.getMonth() + 1).padStart(2, "0"),
		yyyy = today.getFullYear(),
		nextYear = yyyy + 1,
		birthday = new Date(dayMonth + yyyy);
	today = new Date(mm + "/" + dd + "/" + yyyy);
	start = new Date(1 + "/" + 1 + "/" + yyyy);
	if (today.getTime() > birthday.getTime()) {
		birthday = dayMonth + nextYear;
	}
	const countDown = new Date(birthday),
		x = setInterval(function () {
			try {
				const now = new Date(),
					distance = countDown.getTime() - now.getTime();
				document.getElementById(prefix + "lastdayago").innerText = 365 - Math.floor(distance / day);
				(document.getElementById(prefix + "days").innerText = Math.floor(distance / day)), (document.getElementById(prefix + "hours").innerText = Math.floor((distance % day) / hour)), (document.getElementById(prefix + "minutes").innerText = Math.floor((distance % hour) / minute)), (document.getElementById(prefix + "seconds").innerText = Math.floor((distance % minute) / second));
				var q = Math.abs(now - start);
				var d = Math.abs(countDown - start);
				var p = (q / d) * 100;
				document.getElementById(prefix + "yearprogressnum").innerHTML = p.toString().substring(0, 7) + "%";
				document.getElementById(prefix + "yearprogressnum").style.width = Math.round(p).toString().substring(0, 7) + "%";
				if (distance < 0) {
					document.getElementById(prefix + "announcer").innerText = surprise;
					document.getElementById(prefix + "announcer").classList.add(textsize);
					document.getElementById(prefix + "yearprogress").style.display = "none";
					document.getElementById(prefix + "countdown").style.display = "none";
					document.getElementById(prefix + "surprise").style.display = "grid";
					document.getElementById(prefix + "lastdayannouncer").style.display = "none";
					jsConfetti.addConfetti({
						emojis: ["🌈", "⚡️", "💥", "✨", "💫", "🌸"],
						confettiColors: ["#ff0a54", "#ff477e", "#ff7096", "#ff85a1", "#fbb1bd", "#f9bec7"],
						confettiRadius: 6,
						confettiNumber: 200,
						emojiSize: 50,
					});
					clearInterval(x);
				}
			} catch { }
		}, 0);
}
