#include <iostream>
#include <fstream>
#include <vector>
#include <string>
#include <ctime>
#include "datum.h"

using namespace std;

class Sastanak
{
protected:
    string opis;
    Datum datum;

public:
    Sastanak(const string &opis, const Datum &datum) : opis(opis), datum(datum) {}
    virtual ~Sastanak() {}

    virtual bool nastupa(int god, int mes, int dan) const
    {
        return datum.Getg() == god && datum.Getm() == mes && datum.Getd() == dan;
    }

    friend ostream &operator<<(ostream &os, const Sastanak &s)
    {
        os << s.opis;
        if (typeid(s) == typeid(Sastanak))
        {
            os << " (" << s.datum << ")";
        }
        else
        {
            os << " od " << s.datum;
        }
        return os;
    }
};

class GodisnjiSastanak : public Sastanak
{
public:
    GodisnjiSastanak(const string &opis, const Datum &datum) : Sastanak(opis, datum) {}

    bool nastupa(int god, int mes, int dan) const override
    {
        return datum.Getd() == dan && datum.Getm() == mes;
    }
};

class MesecniSastanak : public Sastanak
{
public:
    MesecniSastanak(const string &opis, const Datum &datum) : Sastanak(opis, datum) {}

    bool nastupa(int god, int mes, int dan) const override
    {
        return datum.Getd() == dan;
    }
};

class NedeljniSastanak : public Sastanak
{
public:
    NedeljniSastanak(const string &opis, const Datum &datum) : Sastanak(opis, datum) {}

    bool nastupa(int god, int mes, int dan) const override
    {
        Datum d(god, mes, dan);
        return datum.danUSedm() == d.danUSedm();
    }
};

class DnevniSastanak : public Sastanak
{
public:
    DnevniSastanak(const string &opis, const Datum &datum) : Sastanak(opis, datum) {}

    bool nastupa(int god, int mes, int dan) const override
    {
        return true;
    }
};

void unosSastanaka()
{
    ofstream file("sastanci.txt", ios::app);
    if (!file)
    {
        cerr << "Greska pri otvaranju datoteke!" << endl;
        return;
    }

    while (true)
    {
        cout << "Da li zelite da unesete novi sastanak? (da/ne): ";
        string odgovor;
        cin >> odgovor;
        if (odgovor != "da")
            break;

        cout << "Unesite opis sastanka: ";
        cin.ignore();
        string opis;
        getline(cin, opis);

        cout << "Unesite datum (godina mesec dan): ";
        int god, mes, dan;
        cin >> god >> mes >> dan;

        cout << "Unesite tip sastanka (J - Jednokratni, G - Godisnji, M - Mesecni, N - Nedeljni, D - Dnevni): ";
        char tip;
        cin >> tip;

        Datum datum(god, mes, dan);
        Sastanak *sastanak = nullptr;

        switch (tip)
        {
        case 'J':
            sastanak = new Sastanak(opis, datum);
            break;
        case 'G':
            sastanak = new GodisnjiSastanak(opis, datum);
            break;
        case 'M':
            sastanak = new MesecniSastanak(opis, datum);
            break;
        case 'N':
            sastanak = new NedeljniSastanak(opis, datum);
            break;
        case 'D':
            sastanak = new DnevniSastanak(opis, datum);
            break;
        default:
            cout << "Nepoznat tip sastanka." << endl;
            continue;
        }

        file << tip << " " << opis << " " << god << " " << mes << " " << dan << endl;
        delete sastanak;
    }

    file.close();
}

void ispisSastanakaZaDanas()
{
    ifstream file("sastanci.txt");
    if (!file)
    {
        cerr << "Greska pri otvaranju datoteke!" << endl;
        return;
    }

    vector<Sastanak *> sastanci;

    // Dobijanje trenutnog datuma
    time_t t = time(0);
    tm *now = localtime(&t);
    int danasGod = now->tm_year + 1900;
    int danasMes = now->tm_mon + 1;
    int danasDan = now->tm_mday;

    char tip;
    string opis;
    int god, mes, dan;

    while (file >> tip)
    {
        file.ignore();
        getline(file, opis, '"');
        file >> god >> mes >> dan;

        Datum datum(god, mes, dan);
        Sastanak *sastanak = nullptr;

        switch (tip)
        {
        case 'J':
            sastanak = new Sastanak(opis, datum);
            break;
        case 'G':
            sastanak = new GodisnjiSastanak(opis, datum);
            break;
        case 'M':
            sastanak = new MesecniSastanak(opis, datum);
            break;
        case 'N':
            sastanak = new NedeljniSastanak(opis, datum);
            break;
        case 'D':
            sastanak = new DnevniSastanak(opis, datum);
            break;
        }

        if (sastanak && sastanak->nastupa(danasGod, danasMes, danasDan))
        {
            cout << *sastanak << endl;
        }

        delete sastanak;
    }

    file.close();
}

int main()
{
    unosSastanaka();
    ispisSastanakaZaDanas();
    return 0;
}