/***************************************************************
 * Name:      cdtekaMain.cpp
 * Purpose:   Code for Application Frame
 * Author:    Petar ()
 * Created:   2025-01-29
 * Copyright: Petar ()
 * License:
 **************************************************************/

#include "cdtekaMain.h"
#include <wx/msgdlg.h>

//(*InternalHeaders(cdtekaFrame)
#include <wx/intl.h>
#include <wx/string.h>
//*)

//helper functions
enum wxbuildinfoformat {
    short_f, long_f };

wxString wxbuildinfo(wxbuildinfoformat format)
{
    wxString wxbuild(wxVERSION_STRING);

    if (format == long_f )
    {
#if defined(__WXMSW__)
        wxbuild << _T("-Windows");
#elif defined(__UNIX__)
        wxbuild << _T("-Linux");
#endif

#if wxUSE_UNICODE
        wxbuild << _T("-Unicode build");
#else
        wxbuild << _T("-ANSI build");
#endif // wxUSE_UNICODE
    }

    return wxbuild;
}

//(*IdInit(cdtekaFrame)
const long cdtekaFrame::ID_LISTBOX1 = wxNewId();
const long cdtekaFrame::ID_BUTTON1 = wxNewId();
const long cdtekaFrame::ID_BUTTON3 = wxNewId();
const long cdtekaFrame::ID_BUTTON2 = wxNewId();
const long cdtekaFrame::ID_STATICTEXT1 = wxNewId();
const long cdtekaFrame::ID_CHOICE1 = wxNewId();
const long cdtekaFrame::ID_STATICTEXT2 = wxNewId();
const long cdtekaFrame::ID_TEXTCTRL1 = wxNewId();
const long cdtekaFrame::ID_STATICTEXT3 = wxNewId();
const long cdtekaFrame::ID_TEXTCTRL2 = wxNewId();
const long cdtekaFrame::ID_STATICTEXT4 = wxNewId();
const long cdtekaFrame::ID_CALENDARCTRL1 = wxNewId();
const long cdtekaFrame::ID_STATICTEXT5 = wxNewId();
const long cdtekaFrame::ID_TEXTCTRL3 = wxNewId();
const long cdtekaFrame::ID_PANEL1 = wxNewId();
const long cdtekaFrame::idMenuQuit = wxNewId();
const long cdtekaFrame::idMenuAbout = wxNewId();
const long cdtekaFrame::ID_STATUSBAR1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(cdtekaFrame,wxFrame)
    //(*EventTable(cdtekaFrame)
    //*)
END_EVENT_TABLE()

cdtekaFrame::cdtekaFrame(wxWindow* parent,wxWindowID id)
{
    //(*Initialize(cdtekaFrame)
    wxBoxSizer* BoxSizer1;
    wxBoxSizer* BoxSizer2;
    wxBoxSizer* BoxSizer3;
    wxFlexGridSizer* FlexGridSizer1;
    wxMenu* Menu1;
    wxMenu* Menu2;
    wxMenuBar* MenuBar1;
    wxMenuItem* MenuItem1;
    wxMenuItem* MenuItem2;
    wxStaticBoxSizer* StaticBoxSizer1;
    wxStaticBoxSizer* StaticBoxSizer2;

    Create(parent, wxID_ANY, _("CDfile"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_FRAME_STYLE, _T("wxID_ANY"));
    BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
    Panel1 = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
    BoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
    StaticBoxSizer1 = new wxStaticBoxSizer(wxVERTICAL, Panel1, _("List of CDs"));
    ListBox1 = new wxListBox(Panel1, ID_LISTBOX1, wxDefaultPosition, wxDefaultSize, 0, 0, 0, wxDefaultValidator, _T("ID_LISTBOX1"));
    StaticBoxSizer1->Add(ListBox1, 1, wxALL|wxEXPAND, 5);
    BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
    btnAdd = new wxButton(Panel1, ID_BUTTON1, _("Add"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
    BoxSizer3->Add(btnAdd, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnSave = new wxButton(Panel1, ID_BUTTON3, _("Save"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
    BoxSizer3->Add(btnSave, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnDel = new wxButton(Panel1, ID_BUTTON2, _("Delete"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
    BoxSizer3->Add(btnDel, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    StaticBoxSizer1->Add(BoxSizer3, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    BoxSizer2->Add(StaticBoxSizer1, 1, wxALL|wxEXPAND, 5);
    StaticBoxSizer2 = new wxStaticBoxSizer(wxHORIZONTAL, Panel1, _("CD details"));
    FlexGridSizer1 = new wxFlexGridSizer(5, 2, 0, 0);
    FlexGridSizer1->AddGrowableCol(1);
    FlexGridSizer1->AddGrowableRow(4);
    StaticText1 = new wxStaticText(Panel1, ID_STATICTEXT1, _("Type"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
    FlexGridSizer1->Add(StaticText1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    chbType = new wxChoice(Panel1, ID_CHOICE1, wxDefaultPosition, wxDefaultSize, 0, 0, 0, wxDefaultValidator, _T("ID_CHOICE1"));
    chbType->SetSelection( chbType->Append(_("Meeting")) );
    FlexGridSizer1->Add(chbType, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    StaticText2 = new wxStaticText(Panel1, ID_STATICTEXT2, _("Title"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT2"));
    FlexGridSizer1->Add(StaticText2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    txtTitle = new wxTextCtrl(Panel1, ID_TEXTCTRL1, _("Text"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL1"));
    FlexGridSizer1->Add(txtTitle, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    StaticText3 = new wxStaticText(Panel1, ID_STATICTEXT3, _("Artist / Author"), wxDefaultPosition, wxSize(41,29), 0, _T("ID_STATICTEXT3"));
    FlexGridSizer1->Add(StaticText3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxSHAPED, 5);
    txtArtist = new wxTextCtrl(Panel1, ID_TEXTCTRL2, _("Text"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL2"));
    FlexGridSizer1->Add(txtArtist, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    StaticText4 = new wxStaticText(Panel1, ID_STATICTEXT4, _("Release date"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT4"));
    FlexGridSizer1->Add(StaticText4, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    calDate = new wxCalendarCtrl(Panel1, ID_CALENDARCTRL1, wxDefaultDateTime, wxDefaultPosition, wxDefaultSize, 0, _T("ID_CALENDARCTRL1"));
    FlexGridSizer1->Add(calDate, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    StaticText5 = new wxStaticText(Panel1, ID_STATICTEXT5, _("Description"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT5"));
    FlexGridSizer1->Add(StaticText5, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    txtDesc = new wxTextCtrl(Panel1, ID_TEXTCTRL3, _("Text"), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE, wxDefaultValidator, _T("ID_TEXTCTRL3"));
    FlexGridSizer1->Add(txtDesc, 1, wxALL|wxEXPAND, 5);
    StaticBoxSizer2->Add(FlexGridSizer1, 1, wxALL|wxEXPAND, 0);
    BoxSizer2->Add(StaticBoxSizer2, 1, wxALL|wxEXPAND, 5);
    Panel1->SetSizer(BoxSizer2);
    BoxSizer2->Fit(Panel1);
    BoxSizer2->SetSizeHints(Panel1);
    BoxSizer1->Add(Panel1, 1, wxALL|wxEXPAND, 0);
    SetSizer(BoxSizer1);
    MenuBar1 = new wxMenuBar();
    Menu1 = new wxMenu();
    MenuItem1 = new wxMenuItem(Menu1, idMenuQuit, _("Quit\tAlt-F4"), _("Quit the application"), wxITEM_NORMAL);
    Menu1->Append(MenuItem1);
    MenuBar1->Append(Menu1, _("&File"));
    Menu2 = new wxMenu();
    MenuItem2 = new wxMenuItem(Menu2, idMenuAbout, _("About\tF1"), _("Show info about this application"), wxITEM_NORMAL);
    Menu2->Append(MenuItem2);
    MenuBar1->Append(Menu2, _("Help"));
    SetMenuBar(MenuBar1);
    StatusBar1 = new wxStatusBar(this, ID_STATUSBAR1, 0, _T("ID_STATUSBAR1"));
    int __wxStatusBarWidths_1[1] = { -1 };
    int __wxStatusBarStyles_1[1] = { wxSB_NORMAL };
    StatusBar1->SetFieldsCount(1,__wxStatusBarWidths_1);
    StatusBar1->SetStatusStyles(1,__wxStatusBarStyles_1);
    SetStatusBar(StatusBar1);
    BoxSizer1->Fit(this);
    BoxSizer1->SetSizeHints(this);

    Connect(ID_LISTBOX1,wxEVT_COMMAND_LISTBOX_SELECTED,(wxObjectEventFunction)&cdtekaFrame::OnListBox1Select);
    Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&cdtekaFrame::OnbtnAddClick);
    Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&cdtekaFrame::OnbtnSaveClick);
    Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&cdtekaFrame::OnbtnDelClick);
    Connect(ID_CHOICE1,wxEVT_COMMAND_CHOICE_SELECTED,(wxObjectEventFunction)&cdtekaFrame::OnchbTypeSelect);
    Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&cdtekaFrame::OntxtTitleText);
    Connect(ID_TEXTCTRL2,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&cdtekaFrame::OntxtArtistText);
    Connect(ID_CALENDARCTRL1,wxEVT_CALENDAR_SEL_CHANGED,(wxObjectEventFunction)&cdtekaFrame::OncalDateChanged);
    Connect(ID_TEXTCTRL3,wxEVT_COMMAND_TEXT_UPDATED,(wxObjectEventFunction)&cdtekaFrame::OntxtDescText);
    Connect(idMenuQuit,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&cdtekaFrame::OnQuit);
    Connect(idMenuAbout,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&cdtekaFrame::OnAbout);
    //*)
}

cdtekaFrame::~cdtekaFrame()
{
    //(*Destroy(cdtekaFrame)
    //*)
}

void cdtekaFrame::OnQuit(wxCommandEvent& event)
{
    Close();
}

void cdtekaFrame::OnAbout(wxCommandEvent& event)
{
    wxString msg = wxbuildinfo(long_f);
    wxMessageBox(msg, _("Welcome to event maker"));
}

void cdtekaFrame::OnbtnAddClick(wxCommandEvent& event)
{
    wxString* rec = FromControls();
    unsigned int rn = fdb->AddRecord(rec);
    if(ListBox1->GetCount()<rn+1)
        ListBox1->AppendAndEnsureVisible(rec[1]);
    else
        ListBox1->SetString(rn,rec[1]);
    ListBox1->SetSelection(rn);
    ToControls(fdb->GetCurRec());
}

void cdtekaFrame::OnbtnSaveClick(wxCommandEvent& event)
{
    if(fdb->GetRecCount()) { // >0
        wxString* rec = FromControls();
        unsigned int rn = fdb->SaveRecord(rec);
        ListBox1->SetString(rn,rec[1]);
        wxMessageBox(_("Record has been saved"),_("Record Saved"));
    } else
        wxMessageBox(_("There is no existing record to save. Please add it instead."),_("Save Failed - Add Record Instead"));
}

void cdtekaFrame::OnbtnDelClick(wxCommandEvent& event)
{
    if(fdb->GetRecCount()) { // >0
        unsigned int oldcr= fdb->GetCurRecNum();
        unsigned int rn = fdb->DeleteRecord();
        //aktivni je zapis iznad
        //brise trenutno selektovanu stavku
        delListItem(oldcr?rn + 1:0);
        //bira prethodnu ili 0-tu stavku ako i dalje ima zapisa
        if(fdb->GetRecCount()) {
            ListBox1->SetSelection(rn);
            ToControls(fdb->GetCurRec());
        }
    }
}

void cdtekaFrame::OnchbTypeSelect(wxCommandEvent& event)
{
}

void cdtekaFrame::OntxtTitleText(wxCommandEvent& event)
{
}

void cdtekaFrame::OntxtArtistText(wxCommandEvent& event)
{
}

void cdtekaFrame::OncalDateChanged(wxCalendarEvent& event)
{
}

void cdtekaFrame::OntxtDescText(wxCommandEvent& event)
{
}
wxString* cdtekaFrame::FromControls() {
    wxString* rec = new wxString[5];
    rec[0]=chbType->GetString(chbType->GetCurrentSelection());
    rec[1]=txtTitle->GetValue();
    rec[2]=txtArtist->GetValue();
    rec[3]=calDate->GetDate().Format(_("%m/%d/%y"));
    rec[4]=txtDesc->GetValue();
    return rec;
}

void cdtekaFrame::delListItem(unsigned int n) {
    //nema komande za brisanje
    //premestaju se kopiranjem vrednosti za jednu stavku iznad
    unsigned int lc = fdb->GetRecCount(); //posle brisanja zapisa u fdb
    for(unsigned int i=n;i<lc;i++)
        ListBox1->SetString(i,ListBox1->GetString(i+1));
    ListBox1->SetString(lc,wxEmptyString);
}

void cdtekaFrame::PopuniList() {
    for(unsigned int i=0;i<fdb->GetRecCount();++i) {
        fdb->SetCurRecNum(i);
        ListBox1->AppendAndEnsureVisible(fdb->GetCurRec()[1]);
    }
}

void cdtekaFrame::ToControls(wxString* zapis) {
    //za datumski podatak
    wxDateTime dt;
    wxString::const_iterator kraj;//kraj za datumski podatak

    chbType->SetSelection(chbType->FindString(zapis[0]));
    txtTitle->SetValue(zapis[1]);
    txtArtist->SetValue(zapis[2]);
    if(dt.ParseFormat(zapis[3],_T("%m/%d/%y"),&kraj))
        calDate->SetDate(dt);
    else
        wxMessageBox(_("Date could not be parsed."),_("Date Error"));
    txtDesc->SetValue(zapis[4]);
}

void cdtekaFrame::OnListBox1Select(wxCommandEvent& event)
{
    int sel = ListBox1->GetSelection();
    if(sel<fdb->GetRecCount())
        fdb->SetCurRecNum(sel);
    else
        ListBox1->SetSelection(fdb->GetCurRecNum());
    ToControls(fdb->GetCurRec());
}
