#ifndef FILEDB_H
#define FILEDB_H

#include <wx/string.h>
#include <wx/ffile.h>
#include <wx/vector.h>
#include <wx/tokenzr.h>

#if __WXMSW__
    #define CRLF "\n"
#else
    #define CRLF "\r"
#endif // __WXMSW__

class FileDB
{
    public:
        FileDB(wxString title, unsigned int numf);
        virtual ~FileDB();
        wxString Getpath() const { return m_path; }
        void Setpath(wxString val) { m_path = val; }
        wxString Getdelim() const { return m_delim; }
        unsigned int GetNumF() const {return m_numf;}
        wxString Gettitle() const { return m_title; }
        unsigned int GetRecCount() const {return m_v->size();}
        void Setdelim(wxString val) { m_delim = val; }
        unsigned int GetCurRecNum() const {return m_curRec;}
        void SetCurRecNum(unsigned int val) { m_curRec = val; }
        wxString* GetCurRec() {return (*m_v)[m_curRec];}
        unsigned int AddRecord(wxString* rec);//vraca broj dodatog zapisa
        unsigned int SaveRecord(wxString* rec);//vraca broj izmenjenog zapisa
        unsigned int DeleteRecord();//brise trenutni zapis i vraca br. prethodnog zapisa
        //... ili 0 ako je brisan 0-ti
        void FromFile();
        void ToFile();

    protected:

    private:
        wxString m_path; // putanja do datoteke
        wxString m_title;// naslov baze podataka/datoteke
        wxString m_delim;// znak za razdvajanje polja u redu datoteke
        wxFFile m_file;// objekat za pristup datoteci
        wxVector<wxString*>* m_v; //pokazivac na vektor zapisa
        void str2vect(wxString txt);// ceo tekst iz datoteke u vektor
        wxString vect2str();// vektor u ceo tekst datoteke (za upis)
        wxArrayString vect2astr();
        wxString* ArrConv(wxArrayString sa);//konverzija u obican niz wxStringova
        void clearV();
        unsigned int m_curRec;//trenutno aktivni zapis
        unsigned int m_numf;//broj polj� u zapisu=redu
};

#endif // FILEDB_H
