#include "FileDB.h"
#include <wx/msgdlg.h>

FileDB::FileDB(wxString title, unsigned int numf):m_path(wxEmptyString), m_delim(_T("|")),
    m_title(title), m_numf(numf)
{
    //ctor
    m_v = new wxVector<wxString*>(1);
    m_v->clear(); //ocistiti za preuzimanje iz datoteke
    FromFile();
    m_curRec = 0;
}

FileDB::~FileDB()
{
    //dtor
    ToFile();
    clearV();
    delete m_v;
}

void FileDB::FromFile() {
    wxString txt;
    if(m_title != wxEmptyString) {
        if(m_file.Open(m_path + m_title + _T(".fdb"),_T("a+"))) {
            if(m_file.ReadAll(&txt,wxConvUTF8)) {
                str2vect(txt);
            } else
                wxMessageBox(_("Data Error"),_("File Content"));
            m_file.Close();
        } else { //greska
            wxMessageBox(_("File Error"),_("File Content"));
        }
    }
}

void FileDB::str2vect(wxString txt) {
    if(!txt) { //empty file, just created
        clearV(); //no records, no vector elements yet
    } else {
        wxArrayString sa;
        wxArrayString m_lines = wxStringTokenize(txt,_T(CRLF),wxTOKEN_STRTOK);
        if (m_lines.size()) {
            clearV();
            for(int i=0; i<m_lines.size();i++) {
                sa = wxStringTokenize(m_lines[i],m_delim,wxTOKEN_RET_EMPTY_ALL);
                m_v->push_back(ArrConv(sa));
                //wxMessageBox(wxString::Format(_("(*m_v)[0][1]: %s"), (*m_v)[0][1]), _T("Sadrzaj datoteke"));
            }
        } else {

        }
    }
}

void FileDB::clearV() {
    for(int i=0;i<m_v->size();i++)
        delete[] (*m_v)[i];
    m_v->clear();
}

wxString* FileDB::ArrConv(wxArrayString sa) {
    wxString* fields = new wxString[m_numf];
    for(int j=0;j<sa.size();j++)
        fields[j] = sa[j];
    return fields;
}

wxString FileDB::vect2str() {
    wxString rez(wxEmptyString), delimStr;
    for(int i=0;i<m_v->size();i++) {
        for(int j=0;j<m_numf;j++) {
            delimStr = (j>0?m_delim:_T(""));
            rez = rez + delimStr + (*m_v)[i][j];
        }
        rez += CRLF;
    }
    return rez;
}

void FileDB::ToFile() {
    if(m_file.Open(m_path + m_title + _T(".fdb"),_T("w+"))) {
        wxString txt=vect2str();
        if(txt!=wxEmptyString) {
            if(!m_file.Write(txt,wxConvUTF8))
                wxMessageBox(wxString::Format(_("Write to file failed: %s"),vect2str()));
        }
        m_file.Close();
    } else { //greska
            wxMessageBox(_("File Error"),_("File Content"));
    }
}

wxArrayString FileDB::vect2astr() {
    wxString rec, delimStr;
    wxArrayString rez;
    for(int i=0;i<m_v->size();i++) {
        for(int j=0;j<m_v[i].size();j++) {
            delimStr = (j>0?m_delim:wxString(wxEmptyString));
            rec += delimStr + (*m_v)[i][j];
        }
        rez.push_back(rec);
    }
    return rez;
}

unsigned int FileDB::AddRecord(wxString* rec) {
    m_v->push_back(rec);
    m_curRec = m_v->size() - 1;
    return m_curRec;
}

unsigned int FileDB::SaveRecord(wxString* rec) {
    //wxMessageBox(wxString::Format(_("Broj zapisa: %d"), GetCurRecNum()));
    if(GetRecCount()) {
        delete[] (*m_v)[m_curRec];
        (*m_v)[m_curRec] = rec;
        return m_curRec;
    } else // 0 - empty
        return AddRecord(rec);
}

unsigned int FileDB::DeleteRecord() {
    if(GetRecCount()) {
        delete[] (*m_v)[m_curRec];
        wxVector<wxString*>::iterator el = m_v->begin();
        for (int i = 0; i < m_curRec; i++) {
            el++;
        }
        m_v->erase(el);
        if(m_curRec) { //>0
            m_curRec--;
            return m_curRec;
        } else
            return 0;
    } else {
        wxMessageBox(_("Nothing to delete"),_("Command ignored"));
        return 0;
    }
}
