import utils, re, os, json

def main():
    utils.cls()
    with open(os.path.join(os.path.dirname(__file__),"databases\index.json"), mode="r", encoding="utf-8") as f:
        database = json.load(f)
        f.close()
    print("Unesite broj indeksa. (IR29/23)")
    while True:
        index = utils.getinput(False, False).upper()
        if re.match(r'..\d\d\/(\d\d)?\d\d', index, flags=re.IGNORECASE):
            try:
                year = f"20{index.split('/')[1]}"[-4:]
                id = index.split('/')[0]
                user = database[year][id]
                break
            except:
                print("Nismo mogli da nadjemo tu godinu")
        else:
            print("Unesite tacan indeks format IR00/00.")
    utils.cls()
    print(f"--------------------------------------------")
    print(f"{id}/{year}:")
    print(f"Ime: {user['fullname']}.")
    print(f"Poeni: {user['points']} poena.")
    print(f"--------------------------------------------")
    maxpoints = 0
    for student in database[year]:
        user = database[year][student]
        if int(user['points']) > maxpoints:
            bestname = user['fullname']
            maxpoints = int(user['points'])
        elif int(user['points']) == maxpoints:
            bestname = f"{bestname}, {user['fullname']}"
    print(f"Najbolji student u {year} je {bestname} sa {maxpoints} poena")
    print(f"--------------------------------------------")
    maxpoints = 0
    for year in database:
        for student in database[year]:
            user = database[year][student]
            if int(user['points']) > maxpoints:
                bestname = user['fullname']
                maxpoints = int(user['points'])
            elif int(user['points']) == maxpoints:
                bestname = f"{bestname}, {user['fullname']}"
    print(f"Najbolji student je {bestname} sa {maxpoints} poena")
    print(f"--------------------------------------------")

if __name__ == "__main__":
    main()