using Avalonia;
using Avalonia.Controls;
using Avalonia.Markup.Xaml;
using RestaurantApp.ViewModels;

namespace RestaurantApp.Views;

public partial class LoginWindow : Window
{
    public LoginWindow()
    {
        InitializeComponent();
#if DEBUG
        this.AttachDevTools();
#endif
        DataContext = new LoginViewModel();
    }

    protected override void OnAttachedToVisualTree(VisualTreeAttachmentEventArgs e)
    {
        base.OnAttachedToVisualTree(e);
        this.FindControl<TextBox>("UsernameBox")?.Focus();
    }
    
    private void InitializeComponent()
    {
        AvaloniaXamlLoader.Load(this);
    }
}