﻿using System.ComponentModel;
using System.Runtime.CompilerServices;
using ReactiveUI;

namespace RestaurantApp.ViewModels;

public class ViewModelBase : ReactiveObject
{
    public event PropertyChangedEventHandler PropertyChanged;
    protected void OnPropertyChanged([CallerMemberName] string propertyName = null)
    {
        PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
    }
    
    // protected void RaisePropertyChanged([CallerMemberName] string propertyName = "")
    // {
    //     RaisePropertyChanged(propertyName);
    // }
}