using System;
using System.Reactive;
using System.Threading.Tasks;
using Avalonia;
using Avalonia.Controls.ApplicationLifetimes;
using ReactiveUI;
using RestaurantApp.Services;

namespace RestaurantApp.ViewModels;

public class LoginViewModel : ViewModelBase
{
    private string _username = string.Empty;
    public string Username
    {
        get => _username;
        set => this.RaiseAndSetIfChanged(ref _username, value);
    }
        
    private string _password = string.Empty;
    public string Password
    {
        get => _password;
        set => this.RaiseAndSetIfChanged(ref _password, value);
    }
        
    private string _errorMessage = string.Empty;
    public string ErrorMessage
    {
        get => _errorMessage;
        set => this.RaiseAndSetIfChanged(ref _errorMessage, value);
    }
        
    public bool HasError => !string.IsNullOrWhiteSpace(ErrorMessage);
        
    public ReactiveCommand<Unit, Unit> LoginCommand { get; }
    public ReactiveCommand<Unit, Unit> RegisterCommand { get; }
        
    public LoginViewModel()
    {
        LoginCommand = ReactiveCommand.CreateFromTask(Login, outputScheduler: RxApp.MainThreadScheduler);
        RegisterCommand = ReactiveCommand.CreateFromTask(Register, outputScheduler: RxApp.MainThreadScheduler);
    }
        
    private async Task Login()
    {
        ErrorMessage = "";
            
        if (string.IsNullOrWhiteSpace(Username) || string.IsNullOrWhiteSpace(Password))
        {
            ErrorMessage = "Please enter both username and password";
            return;
        }
            
        try
        {
            var isValid = DatabaseService.ValidateLogin(Username, Password);
            if (isValid)
            {
                // Login successful - show main window
                var mainWindow = new Views.MainWindow();
                mainWindow.Show();
                    
                // Close login window
                if (Application.Current?.ApplicationLifetime is IClassicDesktopStyleApplicationLifetime desktop)
                {
                    desktop.MainWindow?.Close();
                    desktop.MainWindow = mainWindow;
                }
            }
            else
            {
                ErrorMessage = "Invalid username or password";
            }
        }
        catch (Exception ex)
        {
            await Utils.ShowError("Login Error", $"Could not connect to database: {ex.Message}");
        }
    }
        
    private async Task Register()
    {
        try
        {
            DatabaseService.ValidateLogin("petar", "petaradmin");
            // Show registration window (placeholder)
            // Login successful - show main window
            var mainWindow = new Views.MainWindow();
            mainWindow.Show();
                    
            // Close login window
            if (Application.Current?.ApplicationLifetime is IClassicDesktopStyleApplicationLifetime desktop)
            {
                desktop.MainWindow?.Close();
                desktop.MainWindow = mainWindow;
            }
        } 
        catch (Exception ex)
        {
            await Utils.ShowError("Login Error", $"Could not connect to database: {ex.Message}");
        }
    }
}