using System.Collections.ObjectModel;
using System.Reactive;
using Avalonia.Threading;
using ReactiveUI;
using RestaurantApp.Models;
using RestaurantApp.Services;

namespace RestaurantApp.ViewModels;

public class DashboardViewModel : ViewModelBase
{
    public int TotalCustomers { get; set; }
    public int UpcomingReservations { get; set; }
    public int TodaysOrders { get; set; }
    public int MenuItemsCount { get; set; }
        
    public ObservableCollection<Reservation> UpcomingReservationsList { get; set; }
    public ObservableCollection<OrderSummary> RecentOrdersList { get; set; }
        
    public ReactiveCommand<Unit, Unit> RefreshCommand { get; }
        
    public DashboardViewModel()
    {
        Dispatcher.UIThread.InvokeAsync(() =>
        {
            TotalCustomers = DatabaseService.GetTotalCustomers();
            UpcomingReservations = DatabaseService.GetUpcomingReservationsCount();
            TodaysOrders = DatabaseService.GetTodaysOrdersCount();
            MenuItemsCount = DatabaseService.GetMenuItemsCount();
            UpcomingReservationsList = new ObservableCollection<Reservation>(DatabaseService.GetUpcomingReservations());
            RecentOrdersList = new ObservableCollection<OrderSummary>(DatabaseService.GetRecentOrders());
        });

        RefreshCommand = ReactiveCommand.Create(RefreshData, outputScheduler: RxApp.MainThreadScheduler);
    }
        
    private void RefreshData()
    {
        OnPropertyChanged(nameof(TotalCustomers));
        OnPropertyChanged(nameof(UpcomingReservations));
        OnPropertyChanged(nameof(TodaysOrders));
        OnPropertyChanged(nameof(MenuItemsCount));
    
        UpcomingReservationsList.Clear();
        foreach (var r in DatabaseService.GetUpcomingReservations())
        {
            UpcomingReservationsList.Add(r);
        }
    
        RecentOrdersList.Clear();
        foreach (var o in DatabaseService.GetRecentOrders())
        {
            RecentOrdersList.Add(o);
        }
    }
}