using System.Threading.Tasks;
using MsBox.Avalonia;
using MsBox.Avalonia.Enums;

namespace RestaurantApp.Services;

public static class Utils
{
    public static async Task ShowError(string title, string message)
    {
        var box = MessageBoxManager.GetMessageBoxStandard(
            title: title,
            text: message,
            icon: Icon.Error
        );
            
        await box.ShowAsync();
    }

    public static async Task<bool> ShowConfirmation(string title, string message)
    {
        var box = MessageBoxManager.GetMessageBoxStandard(
            title: title,
            text: message,
            ButtonEnum.YesNo,
            icon: Icon.Question
        );

        return await box.ShowAsync() == ButtonResult.Yes;
    }
}