using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Reflection.Emit;
using HarmonyLib;
using RainMeadow;

#pragma warning disable CS8625 // Cannot convert null literal to non-nullable reference type.
#pragma warning disable CS8618 // Non-nullable field must contain a non-null value when exiting constructor. Consider adding the 'required' modifier or declaring as nullable.
#pragma warning disable CS8602 // Dereference of a possibly null reference.

namespace RainGradient;

public class RainGradientMeadowCompat
{
    public static bool Initialized;
    public static void Initialize()
    {
        if (!Initialized)
        {
            RainGradient.Log("Running Compatibility Patches");
            Initialized = true;
        }
    }
    
    public static bool PlayerIsLocal(Player player)
    {
        Initialize();
        return player.IsLocal();
    }

    public static bool GameIsMeadow()
    {
        Initialize();
        return OnlineManager.lobby != null;
    }
}