#version 330 core

#include "Deferred_inc.glsl"

//-------------------------------------------------------------------------------------------------------------------------
//                                  Shader Params
//-------------------------------------------------------------------------------------------------------------------------
uniform sampler2D uTexture;

//-------------------------------------------------------------------------------------------------------------------------
//                                  In
//-------------------------------------------------------------------------------------------------------------------------
in vec2 fragTexCoords;

//-------------------------------------------------------------------------------------------------------------------------
//                                  Out
//-------------------------------------------------------------------------------------------------------------------------
#if USE_LBUFFER_COMPRESSION
layout(location = 0) out vec2 outColor;
#else
layout(location = 0) out vec3 outColor;
#endif

//-------------------------------------------------------------------------------------------------------------------------

void main()
{
    vec4 texel = texture(uTexture, fragTexCoords);

    if (texel.a == 0.0) discard;

#if USE_LBUFFER_COMPRESSION
    outColor.rg = encodeLightCompressed(texel.rgb, ivec2(gl_FragCoord.xy));
#else
    outColor.rgb = texel.rgb;
#endif
}
