#version 150 core

//-------------------------------------------------------------------------------------------------------------------------
//                                  Shader Params
//-------------------------------------------------------------------------------------------------------------------------
uniform sampler2D uHiZBuffer;

//-------------------------------------------------------------------------------------------------------------------------
//                                  In
//-------------------------------------------------------------------------------------------------------------------------
in vec2 fragTexCoords;

//-------------------------------------------------------------------------------------------------------------------------
//                                  Out
//-------------------------------------------------------------------------------------------------------------------------
// none : we only write the gl_FragDepth

//-------------------------------------------------------------------------------------------------------------------------

void main(void)
{
    vec4 texels;
    texels.x = texture( uHiZBuffer, fragTexCoords ).x;
    texels.y = textureOffset( uHiZBuffer, fragTexCoords, ivec2(-1, 0) ).x;
    texels.z = textureOffset( uHiZBuffer, fragTexCoords, ivec2(-1,-1) ).x;
    texels.w = textureOffset( uHiZBuffer, fragTexCoords, ivec2( 0,-1) ).x;

    float maxZ = max( max( texels.x, texels.y ), max( texels.z, texels.w ) );
	
    gl_FragDepth = maxZ;
}
