#version 330 core

//-------------------------------------------------------------------------------------------------------------------------
//                                  Shader Params
//-------------------------------------------------------------------------------------------------------------------------
uniform mat4 uMVPMatrix;
uniform mat4 uModelMatrix;

//-------------------------------------------------------------------------------------------------------------------------
//                                  Vertex Attributes
//-------------------------------------------------------------------------------------------------------------------------
in vec3 vertPosition;
in vec2 vertTexCoords;

//-------------------------------------------------------------------------------------------------------------------------
//                                  Out
//-------------------------------------------------------------------------------------------------------------------------
out vec3 fragPosition;
out vec2 fragTexCoords;

//-------------------------------------------------------------------------------------------------------------------------

void main()
{
    gl_Position = uMVPMatrix * vec4(vertPosition, 1.0);

    vec4 positionWS = uModelMatrix * vec4(vertPosition, 1.0);
    fragPosition = positionWS.xyz;
    fragTexCoords = vertTexCoords;
}
