using System;

namespace Epic.OnlineServices.RTCData;

public struct DataReceivedCallbackInfo : ICallbackInfo
{
	public object ClientData { get; set; }

	public ProductUserId LocalUserId { get; set; }

	public Utf8String RoomName { get; set; }

	public ArraySegment<byte> Data { get; set; }

	public ProductUserId ParticipantId { get; set; }

	public Result? GetResultCode()
	{
		return null;
	}

	internal void Set(ref DataReceivedCallbackInfoInternal other)
	{
		ClientData = other.ClientData;
		LocalUserId = other.LocalUserId;
		RoomName = other.RoomName;
		Data = other.Data;
		ParticipantId = other.ParticipantId;
	}
}
