using System;

namespace Epic.OnlineServices.PlayerDataStorage;

public sealed class PlayerDataStorageInterface : Handle
{
	public const int CopyfilemetadataatindexApiLatest = 1;

	public const int CopyfilemetadataatindexoptionsApiLatest = 1;

	public const int CopyfilemetadatabyfilenameApiLatest = 1;

	public const int CopyfilemetadatabyfilenameoptionsApiLatest = 1;

	public const int DeletecacheApiLatest = 1;

	public const int DeletecacheoptionsApiLatest = 1;

	public const int DeletefileApiLatest = 1;

	public const int DeletefileoptionsApiLatest = 1;

	public const int DuplicatefileApiLatest = 1;

	public const int DuplicatefileoptionsApiLatest = 1;

	public const int FilemetadataApiLatest = 3;

	public const int FilenameMaxLengthBytes = 64;

	public const int GetfilemetadatacountApiLatest = 1;

	public const int GetfilemetadatacountoptionsApiLatest = 1;

	public const int QueryfileApiLatest = 1;

	public const int QueryfilelistApiLatest = 2;

	public const int QueryfilelistoptionsApiLatest = 2;

	public const int QueryfileoptionsApiLatest = 1;

	public const int ReadfileApiLatest = 2;

	public const int ReadfileoptionsApiLatest = 2;

	public const int TimeUndefined = -1;

	public const int WritefileApiLatest = 2;

	public const int WritefileoptionsApiLatest = 2;

	public PlayerDataStorageInterface()
	{
	}

	public PlayerDataStorageInterface(IntPtr innerHandle)
		: base(innerHandle)
	{
	}

	public Result CopyFileMetadataAtIndex(ref CopyFileMetadataAtIndexOptions copyFileMetadataOptions, out FileMetadata? outMetadata)
	{
		CopyFileMetadataAtIndexOptionsInternal copyFileMetadataOptions2 = default(CopyFileMetadataAtIndexOptionsInternal);
		copyFileMetadataOptions2.Set(ref copyFileMetadataOptions);
		IntPtr outMetadata2 = IntPtr.Zero;
		Result result = Bindings.EOS_PlayerDataStorage_CopyFileMetadataAtIndex(base.InnerHandle, ref copyFileMetadataOptions2, ref outMetadata2);
		Helper.Dispose(ref copyFileMetadataOptions2);
		Helper.Get<FileMetadataInternal, FileMetadata>(outMetadata2, out outMetadata);
		if (outMetadata.HasValue)
		{
			Bindings.EOS_PlayerDataStorage_FileMetadata_Release(outMetadata2);
		}
		return result;
	}

	public Result CopyFileMetadataByFilename(ref CopyFileMetadataByFilenameOptions copyFileMetadataOptions, out FileMetadata? outMetadata)
	{
		CopyFileMetadataByFilenameOptionsInternal copyFileMetadataOptions2 = default(CopyFileMetadataByFilenameOptionsInternal);
		copyFileMetadataOptions2.Set(ref copyFileMetadataOptions);
		IntPtr outMetadata2 = IntPtr.Zero;
		Result result = Bindings.EOS_PlayerDataStorage_CopyFileMetadataByFilename(base.InnerHandle, ref copyFileMetadataOptions2, ref outMetadata2);
		Helper.Dispose(ref copyFileMetadataOptions2);
		Helper.Get<FileMetadataInternal, FileMetadata>(outMetadata2, out outMetadata);
		if (outMetadata.HasValue)
		{
			Bindings.EOS_PlayerDataStorage_FileMetadata_Release(outMetadata2);
		}
		return result;
	}

	public Result DeleteCache(ref DeleteCacheOptions options, object clientData, OnDeleteCacheCompleteCallback completionCallback)
	{
		DeleteCacheOptionsInternal options2 = default(DeleteCacheOptionsInternal);
		options2.Set(ref options);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnDeleteCacheCompleteCallbackInternal onDeleteCacheCompleteCallbackInternal = OnDeleteCacheCompleteCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionCallback, onDeleteCacheCompleteCallbackInternal);
		Result result = Bindings.EOS_PlayerDataStorage_DeleteCache(base.InnerHandle, ref options2, clientDataAddress, onDeleteCacheCompleteCallbackInternal);
		Helper.Dispose(ref options2);
		return result;
	}

	public void DeleteFile(ref DeleteFileOptions deleteOptions, object clientData, OnDeleteFileCompleteCallback completionCallback)
	{
		DeleteFileOptionsInternal deleteOptions2 = default(DeleteFileOptionsInternal);
		deleteOptions2.Set(ref deleteOptions);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnDeleteFileCompleteCallbackInternal onDeleteFileCompleteCallbackInternal = OnDeleteFileCompleteCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionCallback, onDeleteFileCompleteCallbackInternal);
		Bindings.EOS_PlayerDataStorage_DeleteFile(base.InnerHandle, ref deleteOptions2, clientDataAddress, onDeleteFileCompleteCallbackInternal);
		Helper.Dispose(ref deleteOptions2);
	}

	public void DuplicateFile(ref DuplicateFileOptions duplicateOptions, object clientData, OnDuplicateFileCompleteCallback completionCallback)
	{
		DuplicateFileOptionsInternal duplicateOptions2 = default(DuplicateFileOptionsInternal);
		duplicateOptions2.Set(ref duplicateOptions);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnDuplicateFileCompleteCallbackInternal onDuplicateFileCompleteCallbackInternal = OnDuplicateFileCompleteCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionCallback, onDuplicateFileCompleteCallbackInternal);
		Bindings.EOS_PlayerDataStorage_DuplicateFile(base.InnerHandle, ref duplicateOptions2, clientDataAddress, onDuplicateFileCompleteCallbackInternal);
		Helper.Dispose(ref duplicateOptions2);
	}

	public Result GetFileMetadataCount(ref GetFileMetadataCountOptions getFileMetadataCountOptions, out int outFileMetadataCount)
	{
		GetFileMetadataCountOptionsInternal getFileMetadataCountOptions2 = default(GetFileMetadataCountOptionsInternal);
		getFileMetadataCountOptions2.Set(ref getFileMetadataCountOptions);
		outFileMetadataCount = Helper.GetDefault<int>();
		Result result = Bindings.EOS_PlayerDataStorage_GetFileMetadataCount(base.InnerHandle, ref getFileMetadataCountOptions2, ref outFileMetadataCount);
		Helper.Dispose(ref getFileMetadataCountOptions2);
		return result;
	}

	public void QueryFile(ref QueryFileOptions queryFileOptions, object clientData, OnQueryFileCompleteCallback completionCallback)
	{
		QueryFileOptionsInternal queryFileOptions2 = default(QueryFileOptionsInternal);
		queryFileOptions2.Set(ref queryFileOptions);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnQueryFileCompleteCallbackInternal onQueryFileCompleteCallbackInternal = OnQueryFileCompleteCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionCallback, onQueryFileCompleteCallbackInternal);
		Bindings.EOS_PlayerDataStorage_QueryFile(base.InnerHandle, ref queryFileOptions2, clientDataAddress, onQueryFileCompleteCallbackInternal);
		Helper.Dispose(ref queryFileOptions2);
	}

	public void QueryFileList(ref QueryFileListOptions queryFileListOptions, object clientData, OnQueryFileListCompleteCallback completionCallback)
	{
		QueryFileListOptionsInternal queryFileListOptions2 = default(QueryFileListOptionsInternal);
		queryFileListOptions2.Set(ref queryFileListOptions);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnQueryFileListCompleteCallbackInternal onQueryFileListCompleteCallbackInternal = OnQueryFileListCompleteCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionCallback, onQueryFileListCompleteCallbackInternal);
		Bindings.EOS_PlayerDataStorage_QueryFileList(base.InnerHandle, ref queryFileListOptions2, clientDataAddress, onQueryFileListCompleteCallbackInternal);
		Helper.Dispose(ref queryFileListOptions2);
	}

	public PlayerDataStorageFileTransferRequest ReadFile(ref ReadFileOptions readOptions, object clientData, OnReadFileCompleteCallback completionCallback)
	{
		ReadFileOptionsInternal readOptions2 = default(ReadFileOptionsInternal);
		readOptions2.Set(ref readOptions);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnReadFileCompleteCallbackInternal onReadFileCompleteCallbackInternal = OnReadFileCompleteCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionCallback, onReadFileCompleteCallbackInternal, readOptions.ReadFileDataCallback, ReadFileOptionsInternal.ReadFileDataCallback, readOptions.FileTransferProgressCallback, ReadFileOptionsInternal.FileTransferProgressCallback);
		IntPtr from = Bindings.EOS_PlayerDataStorage_ReadFile(base.InnerHandle, ref readOptions2, clientDataAddress, onReadFileCompleteCallbackInternal);
		Helper.Dispose(ref readOptions2);
		Helper.Get(from, out PlayerDataStorageFileTransferRequest to);
		return to;
	}

	public PlayerDataStorageFileTransferRequest WriteFile(ref WriteFileOptions writeOptions, object clientData, OnWriteFileCompleteCallback completionCallback)
	{
		WriteFileOptionsInternal writeOptions2 = default(WriteFileOptionsInternal);
		writeOptions2.Set(ref writeOptions);
		IntPtr clientDataAddress = IntPtr.Zero;
		OnWriteFileCompleteCallbackInternal onWriteFileCompleteCallbackInternal = OnWriteFileCompleteCallbackInternalImplementation;
		Helper.AddCallback(out clientDataAddress, clientData, completionCallback, onWriteFileCompleteCallbackInternal, writeOptions.WriteFileDataCallback, WriteFileOptionsInternal.WriteFileDataCallback, writeOptions.FileTransferProgressCallback, WriteFileOptionsInternal.FileTransferProgressCallback);
		IntPtr from = Bindings.EOS_PlayerDataStorage_WriteFile(base.InnerHandle, ref writeOptions2, clientDataAddress, onWriteFileCompleteCallbackInternal);
		Helper.Dispose(ref writeOptions2);
		Helper.Get(from, out PlayerDataStorageFileTransferRequest to);
		return to;
	}

	[MonoPInvokeCallback(typeof(OnDeleteCacheCompleteCallbackInternal))]
	internal static void OnDeleteCacheCompleteCallbackInternalImplementation(ref DeleteCacheCallbackInfoInternal data)
	{
		if (Helper.TryGetAndRemoveCallback<DeleteCacheCallbackInfoInternal, OnDeleteCacheCompleteCallback, DeleteCacheCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnDeleteFileCompleteCallbackInternal))]
	internal static void OnDeleteFileCompleteCallbackInternalImplementation(ref DeleteFileCallbackInfoInternal data)
	{
		if (Helper.TryGetAndRemoveCallback<DeleteFileCallbackInfoInternal, OnDeleteFileCompleteCallback, DeleteFileCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnDuplicateFileCompleteCallbackInternal))]
	internal static void OnDuplicateFileCompleteCallbackInternalImplementation(ref DuplicateFileCallbackInfoInternal data)
	{
		if (Helper.TryGetAndRemoveCallback<DuplicateFileCallbackInfoInternal, OnDuplicateFileCompleteCallback, DuplicateFileCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnFileTransferProgressCallbackInternal))]
	internal static void OnFileTransferProgressCallbackInternalImplementation(ref FileTransferProgressCallbackInfoInternal data)
	{
		if (Helper.TryGetStructCallback<FileTransferProgressCallbackInfoInternal, OnFileTransferProgressCallback, FileTransferProgressCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnQueryFileCompleteCallbackInternal))]
	internal static void OnQueryFileCompleteCallbackInternalImplementation(ref QueryFileCallbackInfoInternal data)
	{
		if (Helper.TryGetAndRemoveCallback<QueryFileCallbackInfoInternal, OnQueryFileCompleteCallback, QueryFileCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnQueryFileListCompleteCallbackInternal))]
	internal static void OnQueryFileListCompleteCallbackInternalImplementation(ref QueryFileListCallbackInfoInternal data)
	{
		if (Helper.TryGetAndRemoveCallback<QueryFileListCallbackInfoInternal, OnQueryFileListCompleteCallback, QueryFileListCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnReadFileCompleteCallbackInternal))]
	internal static void OnReadFileCompleteCallbackInternalImplementation(ref ReadFileCallbackInfoInternal data)
	{
		if (Helper.TryGetAndRemoveCallback<ReadFileCallbackInfoInternal, OnReadFileCompleteCallback, ReadFileCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnReadFileDataCallbackInternal))]
	internal static ReadResult OnReadFileDataCallbackInternalImplementation(ref ReadFileDataCallbackInfoInternal data)
	{
		if (Helper.TryGetStructCallback<ReadFileDataCallbackInfoInternal, OnReadFileDataCallback, ReadFileDataCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			return callback(ref callbackInfo);
		}
		return Helper.GetDefault<ReadResult>();
	}

	[MonoPInvokeCallback(typeof(OnWriteFileCompleteCallbackInternal))]
	internal static void OnWriteFileCompleteCallbackInternalImplementation(ref WriteFileCallbackInfoInternal data)
	{
		if (Helper.TryGetAndRemoveCallback<WriteFileCallbackInfoInternal, OnWriteFileCompleteCallback, WriteFileCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			callback(ref callbackInfo);
		}
	}

	[MonoPInvokeCallback(typeof(OnWriteFileDataCallbackInternal))]
	internal static WriteResult OnWriteFileDataCallbackInternalImplementation(ref WriteFileDataCallbackInfoInternal data, IntPtr outDataBuffer, ref uint outDataWritten)
	{
		if (Helper.TryGetStructCallback<WriteFileDataCallbackInfoInternal, OnWriteFileDataCallback, WriteFileDataCallbackInfo>(ref data, out var callback, out var callbackInfo))
		{
			ArraySegment<byte> outDataBuffer2;
			WriteResult result = callback(ref callbackInfo, out outDataBuffer2);
			Helper.Get(outDataBuffer2, out outDataWritten);
			Helper.Copy(outDataBuffer2, outDataBuffer);
			return result;
		}
		return Helper.GetDefault<WriteResult>();
	}
}
