namespace Epic.OnlineServices.Lobby;

public struct CreateLobbyOptions
{
	public ProductUserId LocalUserId { get; set; }

	public uint MaxLobbyMembers { get; set; }

	public LobbyPermissionLevel PermissionLevel { get; set; }

	public bool PresenceEnabled { get; set; }

	public bool AllowInvites { get; set; }

	public Utf8String BucketId { get; set; }

	public bool DisableHostMigration { get; set; }

	public bool EnableRTCRoom { get; set; }

	public LocalRTCOptions? LocalRTCOptions { get; set; }

	public Utf8String LobbyId { get; set; }

	public bool EnableJoinById { get; set; }

	public bool RejoinAfterKickRequiresInvite { get; set; }

	public uint[] AllowedPlatformIds { get; set; }

	public bool CrossplayOptOut { get; set; }

	public LobbyRTCRoomJoinActionType RTCRoomJoinActionType { get; set; }
}
