using System;
using System.Runtime.InteropServices;

namespace Epic.OnlineServices.Leaderboards;

[StructLayout(LayoutKind.Sequential, Pack = 8)]
internal struct OnQueryLeaderboardRanksCompleteCallbackInfoInternal : ICallbackInfoInternal, IGettable<OnQueryLeaderboardRanksCompleteCallbackInfo>, ISettable<OnQueryLeaderboardRanksCompleteCallbackInfo>, IDisposable
{
	private Result m_ResultCode;

	private IntPtr m_ClientData;

	private IntPtr m_LeaderboardId;

	public Result ResultCode
	{
		get
		{
			return m_ResultCode;
		}
		set
		{
			m_ResultCode = value;
		}
	}

	public object ClientData
	{
		get
		{
			Helper.Get(m_ClientData, out object to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_ClientData);
		}
	}

	public IntPtr ClientDataAddress => m_ClientData;

	public Utf8String LeaderboardId
	{
		get
		{
			Helper.Get(m_LeaderboardId, out Utf8String to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_LeaderboardId);
		}
	}

	public void Set(ref OnQueryLeaderboardRanksCompleteCallbackInfo other)
	{
		ResultCode = other.ResultCode;
		ClientData = other.ClientData;
		LeaderboardId = other.LeaderboardId;
	}

	public void Set(ref OnQueryLeaderboardRanksCompleteCallbackInfo? other)
	{
		if (other.HasValue)
		{
			ResultCode = other.Value.ResultCode;
			ClientData = other.Value.ClientData;
			LeaderboardId = other.Value.LeaderboardId;
		}
	}

	public void Dispose()
	{
		Helper.Dispose(ref m_ClientData);
		Helper.Dispose(ref m_LeaderboardId);
	}

	public void Get(out OnQueryLeaderboardRanksCompleteCallbackInfo output)
	{
		output = default(OnQueryLeaderboardRanksCompleteCallbackInfo);
		output.Set(ref this);
	}
}
