using System;
using System.Runtime.InteropServices;

namespace Epic.OnlineServices.IntegratedPlatform;

[StructLayout(LayoutKind.Sequential, Pack = 8)]
internal struct SteamOptionsInternal : IGettable<SteamOptions>, ISettable<SteamOptions>, IDisposable
{
	private int m_ApiVersion;

	private IntPtr m_OverrideLibraryPath;

	private uint m_SteamMajorVersion;

	private uint m_SteamMinorVersion;

	private IntPtr m_SteamApiInterfaceVersionsArray;

	private uint m_SteamApiInterfaceVersionsArrayBytes;

	public Utf8String OverrideLibraryPath
	{
		get
		{
			Helper.Get(m_OverrideLibraryPath, out Utf8String to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_OverrideLibraryPath);
		}
	}

	public uint SteamMajorVersion
	{
		get
		{
			return m_SteamMajorVersion;
		}
		set
		{
			m_SteamMajorVersion = value;
		}
	}

	public uint SteamMinorVersion
	{
		get
		{
			return m_SteamMinorVersion;
		}
		set
		{
			m_SteamMinorVersion = value;
		}
	}

	public Utf8String SteamApiInterfaceVersionsArray
	{
		get
		{
			Helper.Get(m_SteamApiInterfaceVersionsArray, out Utf8String to);
			return to;
		}
		set
		{
			Helper.Set(value, ref m_SteamApiInterfaceVersionsArray);
		}
	}

	public uint SteamApiInterfaceVersionsArrayBytes
	{
		get
		{
			return m_SteamApiInterfaceVersionsArrayBytes;
		}
		set
		{
			m_SteamApiInterfaceVersionsArrayBytes = value;
		}
	}

	public void Set(ref SteamOptions other)
	{
		m_ApiVersion = 3;
		OverrideLibraryPath = other.OverrideLibraryPath;
		SteamMajorVersion = other.SteamMajorVersion;
		SteamMinorVersion = other.SteamMinorVersion;
		SteamApiInterfaceVersionsArray = other.SteamApiInterfaceVersionsArray;
		SteamApiInterfaceVersionsArrayBytes = other.SteamApiInterfaceVersionsArrayBytes;
	}

	public void Set(ref SteamOptions? other)
	{
		if (other.HasValue)
		{
			m_ApiVersion = 3;
			OverrideLibraryPath = other.Value.OverrideLibraryPath;
			SteamMajorVersion = other.Value.SteamMajorVersion;
			SteamMinorVersion = other.Value.SteamMinorVersion;
			SteamApiInterfaceVersionsArray = other.Value.SteamApiInterfaceVersionsArray;
			SteamApiInterfaceVersionsArrayBytes = other.Value.SteamApiInterfaceVersionsArrayBytes;
		}
	}

	public void Dispose()
	{
		Helper.Dispose(ref m_OverrideLibraryPath);
		Helper.Dispose(ref m_SteamApiInterfaceVersionsArray);
	}

	public void Get(out SteamOptions output)
	{
		output = default(SteamOptions);
		output.Set(ref this);
	}
}
