using BepInEx;
using BepInEx.Configuration;
using BepInEx.Logging;
using BepInEx.Unity.IL2CPP;
using HarmonyLib;
using ValkoGames.Antarctic.AI.Dave;
using ValkoGames.Antarctic.AI.Stalker;
using ValkoGames.Antarctic.Players;
using ValkoGames.Core.AI;
using ValkoGames.Core.Players;

namespace CryoStamina;

[BepInPlugin(PluginInfo.PluginGUID, PluginInfo.PluginName, PluginInfo.PluginVersion)]
[BepInProcess("Cryo.exe")]
public class Plugin : BasePlugin
{
    // Config entries
    public static ConfigEntry<int> MaxStamina;
    public static ConfigEntry<bool> InfiniteStamina;
    
    public override void Load()
    {
        // Create config entries
        MaxStamina = Config.Bind("Stamina", "Max Stamina", 12, 
            "Max Stamina to have");
        InfiniteStamina = Config.Bind("Stamina", "Infinite Stamina", true, 
            "Whether or not to drain stamina");
        
        Log.LogInfo($"Plugin {PluginInfo.PluginGUID} is loaded!");
        
        var harmony = new Harmony($"{PluginInfo.PluginGUID}");
        harmony.PatchAll(typeof(StaminaPatch));
        harmony.PatchAll(typeof(FreezePatch));
        harmony.PatchAll(typeof(AIPatch));
    }
}

public class StaminaPatch
{
    [HarmonyPatch(typeof(PlayerController), "Update")]
    [HarmonyPrefix]
    public static void PlayerController_Update(PlayerController __instance)
    {
        __instance.maxStamina = Plugin.MaxStamina.Value;
        if (Plugin.InfiniteStamina.Value)
        {
            __instance.stamina = __instance.maxStamina;
        }
    }
}

public class FreezePatch
{
    [HarmonyPatch(typeof(PlayerAntarctic), "Update")]
    [HarmonyPrefix]
    public static void PlayerFreezeController_Update(PlayerAntarctic __instance)
    {
        __instance.freezeValue = 0;
        __instance.FreezeController.FreezeValue = 0;
        __instance.FreezeController.difficultyFreezeSpeedMultiplier = -1;
    }
}

public class AIPatch
{
    [HarmonyPatch(typeof(MonsterStalker), "Update")]
    [HarmonyPrefix]
    public static void Monster_Update(MonsterStalker __instance)
    {
        __instance.ServerStopAI();
    }
    
    [HarmonyPatch(typeof(MonsterDave), "Update")]
    [HarmonyPrefix]
    public static void MonsterDave_Update(MonsterStalker __instance)
    {
        __instance.ServerStopAI();
    }
}