using HarmonyLib;
using Steamworks;
using UnityEngine;

namespace AtlyssCrackedLobbies;

public class SteamLobbyPatches
{
    [HarmonyPatch(typeof(SteamLobby), "OnGetLobbyList")]
    [HarmonyPrefix]
    public static bool Prefix()
    {
        return false;
    }
    
    [HarmonyPatch(typeof(SteamLobby), "OnGetLobbyList")]
    [HarmonyPostfix]
    public static void Postfix(SteamLobby __instance, LobbyMatchList_t _result)
    {
        Plugin.Logger.LogInfo("Fetching Lobbies");
        if (LobbyListManager._current._lobbyListEntries.Count > 0)
        {
            LobbyListManager._current.Clear_Lobbylist();
        }
        int num = 0;
        while (num < _result.m_nLobbiesMatching)
        {
            CSteamID lobbyByIndex = SteamMatchmaking.GetLobbyByIndex(num);
            if (SteamMatchmaking.GetLobbyData(lobbyByIndex, "ver") == Application.version)
            {
                __instance._lobbyIds.Add(lobbyByIndex);
                SteamMatchmaking.RequestLobbyData(lobbyByIndex);
            }
            num++;
        }
    }
}